/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.ToolboxHandler;
import blusunrize.immersiveengineering.common.CommonProxy;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration2;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemInternalStorage;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemToolbox
extends ItemInternalStorage
implements IEItemInterfaces.IGuiItem {
    public static final int SLOT_COUNT = 23;

    public ItemToolbox() {
        super("toolbox", 1, new String[0]);
        ToolboxHandler.addToolType(new Predicate<ItemStack>(){
            final Set<String> set = Sets.newHashSet((Object[])Config.IEConfig.Tools.toolbox_tools);

            @Override
            public boolean test(ItemStack stack) {
                return this.set.contains(stack.func_77973_b().getRegistryName().toString());
            }
        });
        ToolboxHandler.addFoodType(new Predicate<ItemStack>(){
            final Set<String> set = Sets.newHashSet((Object[])Config.IEConfig.Tools.toolbox_foods);

            @Override
            public boolean test(ItemStack stack) {
                return this.set.contains(stack.func_77973_b().getRegistryName().toString());
            }
        });
        ToolboxHandler.addWiringType(new BiPredicate<ItemStack, World>(){
            final Set<String> set = Sets.newHashSet((Object[])Config.IEConfig.Tools.toolbox_wiring);

            @Override
            public boolean test(ItemStack stack, World world) {
                return this.set.contains(stack.func_77973_b().getRegistryName().toString());
            }
        });
    }

    @Override
    public int getGuiID(ItemStack stack) {
        return 66;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            CommonProxy.openGuiForItem(player, hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!block.func_176200_f((IBlockAccess)world, pos)) {
                pos = pos.func_177972_a(side);
            }
            if (stack.func_190916_E() != 0 && player.func_175151_a(pos, side, stack) && world.func_190527_a(IEContent.blockMetalDecoration2, pos, false, side, null)) {
                IBlockState toolbox = IEContent.blockMetalDecoration2.func_176203_a(BlockTypes_MetalDecoration2.TOOLBOX.getMeta());
                if (world.func_180501_a(pos, toolbox, 3)) {
                    IEContent.blockMetalDecoration2.onIEBlockPlacedBy(world, pos, toolbox, side, hitX, hitY, hitZ, (EntityLivingBase)player, stack);
                    SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    stack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 23;
    }
}

