/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.reference;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.reference.BoundedEntityReference;
import org.squiddev.plethora.api.reference.EntityReference;
import org.squiddev.plethora.api.reference.IReference;
import org.squiddev.plethora.api.reference.IdentityReference;
import org.squiddev.plethora.api.reference.TileReference;

public final class Reference {
    private Reference() {
        throw new IllegalStateException("Cannot instantiate singleton " + this.getClass().getName());
    }

    @Nonnull
    public static <T> IReference<T> id(T object) {
        return new IdentityReference<T>(object);
    }

    @Nonnull
    public static <T extends TileEntity> IReference<T> tile(T object) {
        return new TileReference<T>(object);
    }

    @Nonnull
    public static <T extends Entity> IReference<T> entity(T object) {
        return new EntityReference<T>(object);
    }

    @Nonnull
    public static <T extends Entity> IReference<T> bounded(T object, IWorldLocation location, int radius) {
        return new BoundedEntityReference<T>(object, location, radius);
    }
}

