/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.wrapper;

import dan200.computercraft.api.lua.LuaException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.ISubTargetedMethod;
import org.squiddev.plethora.api.method.IUnbakedContext;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.module.IModuleMethod;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.wrapper.MethodClassLoader;

final class MethodInstance<T, U>
implements IModuleMethod<T>,
ISubTargetedMethod<T, U> {
    final Method method;
    private final String id;
    private final String name;
    private final Class<T> target;
    private final String documentation;
    final boolean worldThread;
    private final ContextInfo[] requiredContext;
    final int totalContext;
    final ResourceLocation[] modules;
    private final Class<?>[] markerIfaces;
    private final Class<U> subtarget;
    private volatile IMethod.Delegate<T> delegate;

    MethodInstance(Method method, Class<T> target, String name, String documentation, boolean worldThread, ContextInfo[] requiredContext, int totalContext, ResourceLocation[] modules, Class<?>[] markerIfaces, Class<U> subtarget) {
        this.method = method;
        this.id = method.getDeclaringClass().getName() + "#" + method.getName() + "(" + target.getSimpleName() + ")";
        this.name = name;
        this.target = target;
        this.documentation = documentation;
        this.worldThread = worldThread;
        this.requiredContext = requiredContext;
        this.totalContext = totalContext;
        this.modules = modules;
        this.markerIfaces = markerIfaces;
        this.subtarget = subtarget;
        if (ConfigCore.Testing.strict) {
            this.delegate = MethodClassLoader.INSTANCE.build(this);
        }
    }

    @Override
    public boolean canApply(@Nonnull IPartialContext<T> context) {
        if (this.modules != null) {
            IModuleContainer moduleContainer = IModuleContainer.class.isAssignableFrom(this.target) ? (IModuleContainer)context.getTarget() : context.getModules();
            ResourceLocation[] resourceLocationArray = this.modules;
            int n = resourceLocationArray.length;
            for (int i = 0; i < n; ++i) {
                ResourceLocation module = resourceLocationArray[i];
                if (moduleContainer.hasModule(module)) continue;
                return false;
            }
        }
        for (ContextInfo info : this.requiredContext) {
            if (info.key == null) {
                if (context.hasContext(info.klass)) continue;
                return false;
            }
            boolean any = false;
            for (String key : info.key) {
                if (!context.hasContext(key, info.klass)) continue;
                any = true;
                break;
            }
            if (any) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public MethodResult apply(@Nonnull IUnbakedContext<T> context, @Nonnull Object[] args) throws LuaException {
        IMethod.Delegate<T> delegate = this.delegate;
        if (delegate == null) {
            MethodInstance methodInstance = this;
            synchronized (methodInstance) {
                delegate = this.delegate;
                if (delegate == null) {
                    delegate = MethodClassLoader.INSTANCE.build(this);
                    this.delegate = delegate;
                }
            }
        }
        return delegate.apply(context, args);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getDocString() {
        return this.documentation;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    @Override
    public boolean has(@Nonnull Class<?> iface) {
        if (this.markerIfaces == null) {
            return false;
        }
        for (Class<?> klass : this.markerIfaces) {
            if (!iface.isAssignableFrom(klass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public Collection<ResourceLocation> getModules() {
        return this.modules == null ? Collections.emptyList() : Arrays.asList(this.modules);
    }

    @Override
    @Nullable
    public Class<U> getSubTarget() {
        return this.subtarget;
    }

    static class ContextInfo {
        private final String[] key;
        private final Class<?> klass;

        ContextInfo(@Nullable String[] key, @Nonnull Class<?> klass) {
            this.key = key;
            this.klass = klass;
        }
    }
}

