/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.notenoughwands;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.integration.ItemEntityStorageMetaProvider;
import romelo333.notenoughwands.Items.CapturingWand;
import romelo333.notenoughwands.ModItems;

@Injects(value="notenoughwands")
public final class IntegrationNEW {
    public static final IMetaProvider<ItemStack> META_CAPTURING_WAND = new ItemEntityStorageMetaProvider<CapturingWand>("capturedEntity", CapturingWand.class, "Provides the entity captured inside this capturing wand."){

        @Override
        @Nullable
        protected Entity spawn(@Nonnull ItemStack stack, @Nonnull CapturingWand item, @Nonnull IWorldLocation location) {
            EntityLivingBase entity;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null || !tag.func_150297_b("type", 8)) {
                return null;
            }
            Class<? extends EntityLivingBase> type = this.getClass(tag.func_74779_i("type"));
            if (type == null) {
                return null;
            }
            try {
                entity = type.getConstructor(World.class).newInstance(location.getWorld());
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                return null;
            }
            entity.func_70037_a(tag.func_74775_l("mob"));
            return entity;
        }

        @Override
        @Nonnull
        protected Map<String, ?> getBasicDetails(@Nonnull ItemStack stack, @Nonnull CapturingWand item) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null || !tag.func_150297_b("type", 8)) {
                return Collections.emptyMap();
            }
            Class<? extends EntityLivingBase> type = this.getClass(tag.func_74779_i("type"));
            if (type == null) {
                return Collections.emptyMap();
            }
            EntityEntry entry = EntityRegistry.getEntry(type);
            if (entry == null) {
                return Collections.emptyMap();
            }
            return 1.getBasicDetails(entry.getRegistryName(), tag.func_74775_l("mob"));
        }

        @Nullable
        private Class<? extends EntityLivingBase> getClass(String type) {
            try {
                return Class.forName(type).asSubclass(EntityLivingBase.class);
            }
            catch (ReflectiveOperationException ignored) {
                return null;
            }
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            ItemStack stack = new ItemStack((Item)ModItems.capturingWand);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("type", EntitySquid.class.getName());
            stack.func_77982_d(tag);
            return stack;
        }
    };

    private IntegrationNEW() {
    }
}

