/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.inventory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.modcrafters.mclib.energy.implementations.GenericEnergyStorage;
import net.ndrei.teslacorelib.capabilities.inventory.ISidedItemHandlerConfig;
import net.ndrei.teslacorelib.energy.EnergySystemFactory;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.IEnergyStatistics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u00042\u00020\u0005B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0016J-\u0010&\u001a\u0004\u0018\u0001H'\"\u0004\b\u0000\u0010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016\u00a2\u0006\u0002\u0010,J\u0006\u0010-\u001a\u00020\u0007J\u0006\u0010.\u001a\u00020\u0007J\u000e\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007J\u001e\u00101\u001a\u00020\u00182\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0010\u00102\u001a\u00020\u00182\b\u0010*\u001a\u0004\u0018\u00010+J\u0006\u00103\u001a\u00020$J\b\u00104\u001a\u00020\u0003H\u0016J\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0007J\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0007J\u000e\u00109\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0007J\u000e\u0010:\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0007J\u001e\u0010;\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007J\u000e\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u0007J\u0016\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020BR$\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R(\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0019R$\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000e\"\u0004\b\u001d\u0010\u0010R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lnet/ndrei/teslacorelib/inventory/EnergyStorage;", "Lnet/modcrafters/mclib/energy/implementations/GenericEnergyStorage;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/NBTTagCompound;", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "Lnet/ndrei/teslacorelib/inventory/IEnergyStatistics;", "maxStoredEnergy", "", "inputRate", "outputRate", "(JJJ)V", "<set-?>", "averageEnergyPerTick", "getAverageEnergyPerTick", "()J", "setAverageEnergyPerTick", "(J)V", "Lnet/minecraft/item/EnumDyeColor;", "color", "getColor", "()Lnet/minecraft/item/EnumDyeColor;", "setColor", "(Lnet/minecraft/item/EnumDyeColor;)V", "isEmpty", "", "()Z", "isFull", "lastTickEnergy", "getLastTickEnergy", "setLastTickEnergy", "sidedConfig", "Lnet/ndrei/teslacorelib/capabilities/inventory/ISidedItemHandlerConfig;", "statStored", "statTicks", "", "deserializeNBT", "", "nbt", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getEnergyInputRate", "getEnergyOutputRate", "givePower", "energy", "hasCapability", "isSideAllowed", "processStatistics", "serializeNBT", "setCapacity", "capacity", "setEnergyInputRate", "rate", "setEnergyOutputRate", "setEnergyTransferRate", "setSidedConfig", "highlight", "Lnet/ndrei/teslacorelib/inventory/BoundingRectangle;", "takePower", "workPerformed", "jobEnergy", "jobPercent", "", "tesla-core-lib"})
public class EnergyStorage
extends GenericEnergyStorage
implements INBTSerializable<NBTTagCompound>,
ICapabilityProvider,
IEnergyStatistics {
    @Nullable
    private EnumDyeColor color;
    private ISidedItemHandlerConfig sidedConfig;
    private long statStored;
    private long averageEnergyPerTick;
    private long lastTickEnergy;
    private final List<Long> statTicks;

    @Nullable
    public final EnumDyeColor getColor() {
        return this.color;
    }

    private final void setColor(EnumDyeColor enumDyeColor) {
        this.color = enumDyeColor;
    }

    @Override
    public final long getAverageEnergyPerTick() {
        return this.averageEnergyPerTick;
    }

    private final void setAverageEnergyPerTick(long l) {
        this.averageEnergyPerTick = l;
    }

    @Override
    public final long getLastTickEnergy() {
        return this.lastTickEnergy;
    }

    private final void setLastTickEnergy(long l) {
        this.lastTickEnergy = l;
    }

    public final long workPerformed(long jobEnergy) {
        return this.workPerformed(jobEnergy, 1.0f);
    }

    public final long workPerformed(long jobEnergy, float jobPercent) {
        long energy = Math.round((double)jobEnergy * (double)Math.max(0.0f, Math.min(1.0f, jobPercent)));
        return this.takePower(energy);
    }

    public final long givePower(long energy) {
        return this.givePower(energy, false, true);
    }

    public final long takePower(long energy) {
        return this.takePower(energy, false, true);
    }

    public final boolean isFull() {
        return this.getCapacity() == this.getStored();
    }

    public final boolean isEmpty() {
        return this.getStored() == 0L;
    }

    @NotNull
    public final EnergyStorage setCapacity(long capacity) {
        long stored = this.getStored();
        this.setCapacity(capacity);
        if (this.getStored() > capacity) {
            this.setStored(capacity);
        }
        if (stored != this.getStored()) {
            this.onChanged(stored, this.getStored());
        }
        return this;
    }

    public final long getEnergyInputRate() {
        return this.getInputRate();
    }

    @NotNull
    public final EnergyStorage setEnergyInputRate(long rate) {
        this.setInputRate(rate);
        this.onChanged(this.getStored(), this.getStored());
        return this;
    }

    public final long getEnergyOutputRate() {
        return this.getOutputRate();
    }

    @NotNull
    public final EnergyStorage setEnergyOutputRate(long rate) {
        this.setOutputRate(rate);
        this.onChanged(this.getStored(), this.getStored());
        return this;
    }

    @NotNull
    public final EnergyStorage setEnergyTransferRate(long rate) {
        this.setEnergyInputRate(rate);
        this.setEnergyOutputRate(rate);
        return this;
    }

    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound dataTag = new NBTTagCompound();
        dataTag.func_74772_a("TeslaPower", this.getStored());
        dataTag.func_74772_a("TeslaCapacity", this.getCapacity());
        dataTag.func_74772_a("TeslaInput", this.getInputRate());
        dataTag.func_74772_a("TeslaOutput", this.getOutputRate());
        return dataTag;
    }

    public void deserializeNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        long originalStored = this.getStored();
        this.setStored(nbt.func_74763_f("TeslaPower"));
        if (nbt.func_74764_b("TeslaCapacity")) {
            this.setCapacity(nbt.func_74763_f("TeslaCapacity"));
        }
        if (nbt.func_74764_b("TeslaInput")) {
            this.setInputRate(nbt.func_74763_f("TeslaInput"));
        }
        if (nbt.func_74764_b("TeslaOutput")) {
            this.setOutputRate(nbt.func_74763_f("TeslaOutput"));
        }
        if (this.getStored() > this.getCapacity()) {
            this.setStored(this.getCapacity());
        }
        if (this.getStored() != originalStored) {
            this.onChanged(originalStored, this.getStored());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSideAllowed(@Nullable EnumFacing facing) {
        if (this.sidedConfig == null) return false;
        if (this.color == null) return false;
        if (facing == null) return false;
        ISidedItemHandlerConfig iSidedItemHandlerConfig = this.sidedConfig;
        if (iSidedItemHandlerConfig == null) {
            Intrinsics.throwNpe();
        }
        EnumDyeColor enumDyeColor = this.color;
        if (enumDyeColor == null) {
            Intrinsics.throwNpe();
        }
        if (!iSidedItemHandlerConfig.isSideSet(enumDyeColor, facing)) return false;
        return true;
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (this.isSideAllowed(facing)) {
            return EnergySystemFactory.INSTANCE.isCapabilitySupported(capability);
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (this.isSideAllowed(facing)) {
            return EnergySystemFactory.INSTANCE.wrapCapability(capability, this);
        }
        return null;
    }

    public final void setSidedConfig(@NotNull EnumDyeColor color, @NotNull ISidedItemHandlerConfig sidedConfig, @NotNull BoundingRectangle highlight) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)sidedConfig, (String)"sidedConfig");
        Intrinsics.checkParameterIsNotNull((Object)highlight, (String)"highlight");
        if (this.sidedConfig == sidedConfig) {
            return;
        }
        this.sidedConfig = sidedConfig;
        this.color = color;
        if (this.sidedConfig != null && this.color != null) {
            ISidedItemHandlerConfig iSidedItemHandlerConfig = this.sidedConfig;
            if (iSidedItemHandlerConfig == null) {
                Intrinsics.throwNpe();
            }
            EnumDyeColor enumDyeColor = this.color;
            if (enumDyeColor == null) {
                Intrinsics.throwNpe();
            }
            iSidedItemHandlerConfig.addColoredInfo("teslacorelib:Energy", enumDyeColor, highlight, -20);
        }
    }

    public final void processStatistics() {
        this.lastTickEnergy = this.getStored() - this.statStored;
        this.statStored = this.getStored();
        this.statTicks.add(this.lastTickEnergy);
        while (this.statTicks.size() > 10) {
            this.statTicks.remove(0);
        }
        long sum = 0L;
        Iterator<Long> iterator = this.statTicks.iterator();
        while (iterator.hasNext()) {
            long l = ((Number)iterator.next()).longValue();
            sum += l;
        }
        this.averageEnergyPerTick = sum / (long)this.statTicks.size();
    }

    public EnergyStorage(long maxStoredEnergy, long inputRate, long outputRate) {
        super(maxStoredEnergy, inputRate, outputRate, 0L, 8, null);
        List list;
        EnergyStorage energyStorage = this;
        energyStorage.statTicks = list = (List)new ArrayList();
    }
}

