/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.delete;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.IDeletionTask;

public class DeleteExpansionSubCommand
extends BasePregenCommand {
    public DeleteExpansionSubCommand() {
        super(7);
        this.addDescription(0, "Deletion Type: Which shape the Generation should have");
        this.addDescription(1, "X Center: Which Chunk the center should be in. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(2, "Z Center: Which Chunk the center should be in. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(3, "Min Radius: The Radius the Deletion should start at. (if 'b' infront of the number or after ~ means block distance)");
        this.addDescription(4, "Max Radius: The Radius the Deletion should end at. (if 'b' infront of the number or after ~ means block distance)");
        this.addDescription(5, "(Optional) Dimension: The Dimension the Deletion should be happening in");
        this.addDescription(6, "(Optional) Delay: How long the Deleter should wait until it should start (in ticks)");
        this.addSuggestion("deleteExpansion square 0 0 100 200 -1", "Deletes a area from 100 Chunks to 200 Chunks in the Nether");
    }

    @Override
    public String getName() {
        return "deleteExpansion";
    }

    @Override
    public String getDescription() {
        return "Deletes a Area of Unloaded Chunks around an Existing Area";
    }

    @Override
    public int getRequiredParameterCount() {
        return 5;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (container.processorRunning()) {
            container.sendChatMessage("While the Pregenerator or Deleter is running you are not allowed to start Deletion Task!");
            return;
        }
        if (args.length >= 5) {
            int type = DeleteExpansionSubCommand.getGenType(args[0]);
            FilePos center = DeleteExpansionSubCommand.getChunkPos(args[1], args[2], container.getPlayerPos());
            int minRadius = DeleteExpansionSubCommand.getNumber(DeleteExpansionSubCommand.getArg(args, 3), 0);
            int maxRadius = DeleteExpansionSubCommand.getNumber(DeleteExpansionSubCommand.getArg(args, 4), 0);
            int dimension = DeleteExpansionSubCommand.getDimension(container, DeleteExpansionSubCommand.getArg(args, 5));
            int delay = DeleteExpansionSubCommand.parseNumber(DeleteExpansionSubCommand.getArg(args, 6), 0);
            if (!DeleteExpansionSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            int ringCount = DeleteExpansionSubCommand.getRingCount(minRadius, maxRadius, type == 1);
            if (ringCount > 4000000) {
                container.sendChatMessage("Expansion uses more then 4 Million Chunks. That is to big. Please make it smaller. (Your Expansion Amount: " + ringCount + ")");
                return;
            }
            container.onProcessStarted();
            container.getDeleter().startTask(new ExpansionTask(type, dimension, center, minRadius, maxRadius, delay));
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return DeleteExpansionSubCommand.getBestMatch(args, CompleterHelper.GEN_TYPE);
        }
        if (commandIndex == 1 || commandIndex == 2) {
            return DeleteExpansionSubCommand.getBestMatch(args, "0", "~");
        }
        if (commandIndex == 3 || commandIndex == 4) {
            if (args[argLayer].startsWith("b")) {
                return DeleteExpansionSubCommand.getBestMatch(args, CompleterHelper.GEN_RADIUS_BLOCK);
            }
            return DeleteExpansionSubCommand.getBestMatch(args, CompleterHelper.GEN_RADIUS_CHUNK);
        }
        if (commandIndex == 5) {
            return DeleteExpansionSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        if (commandIndex == 6) {
            return DeleteExpansionSubCommand.getBestMatch(args, CompleterHelper.GEN_DELAY);
        }
        return new ArrayList<String>();
    }

    public static class ExpansionTask
    extends IDeletionTask {
        int type;
        int dim;
        FilePos center;
        int minRadius;
        int maxRadius;

        public ExpansionTask(int type, int dim, FilePos center, int minRadius, int maxRadius, int delay) {
            super(delay);
            this.type = type;
            this.dim = dim;
            this.center = center;
            this.minRadius = minRadius;
            this.maxRadius = maxRadius;
        }

        @Override
        public DeleteProcess createTask() {
            boolean loaded = DimensionManager.getWorld((int)this.dim) != null;
            WorldServer world = this.getWorld(this.dim);
            DeleteProcess process = new DeleteProcess(world.getChunkSaveLocation(), this.type == 1 ? ChunkCalculator.createcircleExt(this.center.x, this.center.z, this.minRadius, this.maxRadius) : ChunkCalculator.createSquareExt(this.center.x, this.center.z, this.minRadius, this.maxRadius));
            if (loaded) {
                process.setChunkHost(world);
            } else {
                DimensionManager.unloadWorld((int)this.dim);
            }
            return process;
        }
    }
}

