/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.delete;

import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.command.delete.DeleteRadiusSubCommand;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.IDeletionTask;

public class DeleteMassSubCommand
extends BasePregenCommand {
    public DeleteMassSubCommand() {
        super(6);
        this.addDescription(0, "Deletion Type: Which shape the Generation should have");
        this.addDescription(1, "X Center: Which Chunk the center should be in. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(2, "Z Center: Which Chunk the center should be in. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(3, "Radius: How big the Radius in Chunks should be. (if 'b' infront of the number or after ~ means block distance)");
        this.addDescription(4, "(Optional) Dimension: The Dimension the Deletion should be happening in");
        this.addDescription(5, "(Optional) Delay: How long the Deleter should wait until it should start (in ticks)");
        this.addSuggestion("deleteMassRadius square 0 0 100 -1 200", "Deletes a 100 Chunk Area around the World Center in the nether and it waits 10 seconds before starting");
    }

    @Override
    public String getName() {
        return "deleteMassRadius";
    }

    @Override
    public String getDescription() {
        return "Deletes a Massive Area";
    }

    @Override
    public int getRequiredParameterCount() {
        return 4;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (container.processorRunning()) {
            container.sendChatMessage("While the Pregenerator or Deleter is running you are not allowed to start Deletion Task!");
            return;
        }
        if (args.length >= 4) {
            int type = DeleteMassSubCommand.getGenType(args[0]);
            FilePos center = DeleteMassSubCommand.getChunkPos(args[1], args[2], container.getPlayerPos());
            int radius = DeleteMassSubCommand.getNumber(DeleteMassSubCommand.getArg(args, 3), 0);
            int dimension = DeleteMassSubCommand.getDimension(container, DeleteMassSubCommand.getArg(args, 4));
            int delay = DeleteMassSubCommand.parseNumber(DeleteMassSubCommand.getArg(args, 5), 0);
            if (!DeleteMassSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            List<IDeletionTask> deletion = DeleteMassSubCommand.createTaskList(type, center, radius, dimension, delay);
            if (deletion.isEmpty()) {
                container.sendChatMessage("No Tasks found");
                return;
            }
            container.sendChatMessage("Created " + deletion.size() + " Tasks");
            container.onProcessStarted();
            container.getDeleter().startTasks(deletion);
        } else {
            this.throwErrors(container, args.length);
        }
    }

    public static List<IDeletionTask> createTaskList(int type, FilePos center, int radius, int dimension, int delay) {
        if (radius <= 1000) {
            ArrayList<IDeletionTask> tasks = new ArrayList<IDeletionTask>();
            tasks.add(new DeleteRadiusSubCommand.RadiusTask(type, dimension, center, radius, delay));
            return tasks;
        }
        int range = DoubleMath.roundToInt((double)((double)radius / 1000.0), (RoundingMode)RoundingMode.UP);
        ArrayList<FilePos> workList = new ArrayList<FilePos>();
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                workList.add(new FilePos(x, z));
            }
        }
        ChunkCalculator.ChunkComparator comp = ChunkCalculator.comparator;
        comp.setCenter(center);
        workList.sort(comp);
        ArrayList<IDeletionTask> task = new ArrayList<IDeletionTask>();
        for (FilePos pos : workList) {
            int xMin = DeleteMassSubCommand.clamp((pos.x - 1) * 1000, -radius, radius);
            int zMin = DeleteMassSubCommand.clamp((pos.z - 1) * 1000, -radius, radius);
            int xMax = DeleteMassSubCommand.clamp((pos.x + 1) * 1000, -radius, radius);
            int zMax = DeleteMassSubCommand.clamp((pos.z + 1) * 1000, -radius, radius);
            if (type == 0) {
                task.add(new MassDeletionSquare(dimension, new FilePos(xMin, zMin), new FilePos(xMax, zMax), delay));
                continue;
            }
            if (type != 1) continue;
            task.add(new MassDeletionCycle(dimension, new FilePos(xMin, zMin), new FilePos(xMax, zMax), center, radius, delay));
        }
        return task;
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return DeleteMassSubCommand.getBestMatch(args, CompleterHelper.GEN_TYPE);
        }
        if (commandIndex == 1 || commandIndex == 2) {
            return DeleteMassSubCommand.getBestMatch(args, "0", "~");
        }
        if (commandIndex == 3) {
            if (args[argLayer].startsWith("b")) {
                return DeleteMassSubCommand.getBestMatch(args, CompleterHelper.GEN_RADIUS_BLOCK);
            }
            return DeleteMassSubCommand.getBestMatch(args, CompleterHelper.GEN_RADIUS_CHUNK);
        }
        if (commandIndex == 4) {
            return DeleteMassSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        if (commandIndex == 5) {
            return DeleteMassSubCommand.getBestMatch(args, CompleterHelper.GEN_DELAY);
        }
        return new ArrayList<String>();
    }

    public static class MassDeletionCycle
    extends IDeletionTask {
        int dim;
        FilePos min;
        FilePos max;
        FilePos center;
        int radius;

        public MassDeletionCycle(int dim, FilePos min, FilePos max, FilePos center, int radius, int delay) {
            super(delay);
            this.dim = dim;
            this.min = min;
            this.max = max;
            this.center = center;
            this.radius = radius;
        }

        @Override
        public DeleteProcess createTask() {
            boolean loaded = DimensionManager.getWorld((int)this.dim) != null;
            WorldServer world = this.getWorld(this.dim);
            DeleteProcess process = new DeleteProcess(world.getChunkSaveLocation(), ChunkCalculator.createcircleArea(this.min.x, this.min.z, this.max.x, this.max.z, this.center.x, this.center.z, this.radius));
            if (loaded) {
                process.setChunkHost(world);
            } else {
                DimensionManager.unloadWorld((int)this.dim);
            }
            return process;
        }
    }

    public static class MassDeletionSquare
    extends IDeletionTask {
        int dim;
        FilePos min;
        FilePos max;

        public MassDeletionSquare(int dim, FilePos min, FilePos max, int delay) {
            super(delay);
            this.dim = dim;
            this.min = min;
            this.max = max;
        }

        @Override
        public DeleteProcess createTask() {
            boolean loaded = DimensionManager.getWorld((int)this.dim) != null;
            WorldServer world = this.getWorld(this.dim);
            DeleteProcess process = new DeleteProcess(world.getChunkSaveLocation(), ChunkCalculator.createArea(this.min.x, this.min.z, this.max.x, this.max.z));
            if (loaded) {
                process.setChunkHost(world);
            } else {
                DimensionManager.unloadWorld((int)this.dim);
            }
            return process;
        }
    }
}

