/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.block.IPlantableBlock;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.client.sounds.GCSounds;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBasicMars
extends Block
implements IDetectableResource,
IPlantableBlock,
ITerraformableBlock,
ISortableBlock {
    public static final PropertyEnum<EnumBlockBasic> BASIC_TYPE = PropertyEnum.func_177709_a((String)"basictypemars", EnumBlockBasic.class);

    public BlockBasicMars(String assetName) {
        super(Material.field_151576_e);
        this.func_149663_c(assetName);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.DUNGEON_BRICK) {
            return MapColor.field_151651_C;
        }
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.SURFACE) {
            return MapColor.field_151664_l;
        }
        return MapColor.field_151645_D;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        EnumBlockBasic type = (EnumBlockBasic)((Object)world.func_180495_p(pos).func_177229_b(BASIC_TYPE));
        if (type == EnumBlockBasic.DUNGEON_BRICK) {
            return 40.0f;
        }
        if (type == EnumBlockBasic.DESH_BLOCK) {
            return 60.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.DUNGEON_BRICK) {
            return 4.0f;
        }
        return this.field_149782_v;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_DESH) {
            return MarsItems.marsItemBasic;
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.MARS_STONE) {
            return 4;
        }
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_DESH) {
            return 0;
        }
        return meta;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_DESH && fortune >= 1) {
            return random.nextFloat() < (float)fortune * 0.29f - 0.25f ? 2 : 1;
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumBlockBasic blockBasic : EnumBlockBasic.values()) {
            list.add((Object)new ItemStack((Block)this, 1, blockBasic.getMeta()));
        }
    }

    public boolean isValueable(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return false;
    }

    public int requiredLiquidBlocksNearby() {
        return 4;
    }

    public boolean isPlantable(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(10) == 0 && state.func_177230_c() == this && state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.DUNGEON_BRICK) {
            GalacticraftPlanets.spawnParticle("sludgeDrip", new Vector3((double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o(), (double)pos.func_177952_p() + rand.nextDouble()), new Vector3(0.0, 0.0, 0.0), new Object[0]);
            if (rand.nextInt(100) == 0) {
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), GCSounds.singleDrip, SoundCategory.AMBIENT, 1.0f, 0.8f + rand.nextFloat() / 5.0f);
            }
        }
    }

    public boolean isTerraformable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        IBlockState stateAbove = world.func_180495_p(pos.func_177984_a());
        return state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.SURFACE && !stateAbove.func_177230_c().func_149686_d(stateAbove);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        return state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.MIDDLE || state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.MARS_STONE;
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177230_c().func_176201_c(state) == 10;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BASIC_TYPE, (Comparable)((Object)EnumBlockBasic.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBlockBasic)((Object)state.func_177229_b(BASIC_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BASIC_TYPE});
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        switch (meta) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return EnumSortCategoryBlock.ORE;
            }
            case 7: {
                return EnumSortCategoryBlock.BRICKS;
            }
            case 8: {
                return EnumSortCategoryBlock.INGOT_BLOCK;
            }
        }
        return EnumSortCategoryBlock.GENERAL;
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        int meta = this.func_176201_c(state);
        if (meta == 2) {
            Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
            return MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
        }
        return 0;
    }

    public static enum EnumBlockBasic implements IStringSerializable
    {
        ORE_COPPER(0, "ore_copper_mars"),
        ORE_TIN(1, "ore_tin_mars"),
        ORE_DESH(2, "ore_desh_mars"),
        ORE_IRON(3, "ore_iron_mars"),
        COBBLESTONE(4, "cobblestone"),
        SURFACE(5, "mars_surface"),
        MIDDLE(6, "mars_middle"),
        DUNGEON_BRICK(7, "dungeon_brick"),
        DESH_BLOCK(8, "desh_block"),
        MARS_STONE(9, "mars_stone");

        private final int meta;
        private final String name;
        private static final EnumBlockBasic[] values;

        private EnumBlockBasic(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumBlockBasic byMetadata(int meta) {
            return values[meta % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = EnumBlockBasic.values();
        }
    }
}

