/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.management;

import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Lang;

public enum AccessRule {
    None(Ic2Lang.accessNothing),
    Import(Ic2Lang.accessImport),
    Export(Ic2Lang.accessExport),
    Both(Ic2Lang.accessBoth);

    LocaleComp name;

    private AccessRule(LocaleComp name) {
        this.name = name;
    }

    public String getName() {
        return this.name.getLocalized();
    }

    public boolean canImport() {
        return this == Import || this == Both;
    }

    public boolean canExport() {
        return this == Export || this == Both;
    }

    public boolean canWorkWith(AccessRule other) {
        if (this == Both) {
            return true;
        }
        if (this == None) {
            return false;
        }
        if (this == Import && (other == Import || other == None)) {
            return true;
        }
        return this == Export && (other == Export || other == None);
    }

    public AccessRule createNextRule(AccessRule rule) {
        if (rule == None) {
            return None;
        }
        if (rule == Both) {
            if (this == Both) {
                return None;
            }
            if (this == None) {
                return Export;
            }
            if (this == Export) {
                return Import;
            }
            return Both;
        }
        if (this == rule) {
            return None;
        }
        return rule;
    }
}

