/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.crop;

import ic2.api.classic.item.ICropAnalyzer;
import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.network.ICustomNetworkItemEventListener;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.item.base.ItemIC2;
import ic2.core.item.inv.container.ContainerCropBreeder;
import ic2.core.item.inv.inventories.CropAnalyzerInventory;
import ic2.core.item.inv.inventories.InventoryCropBreeder;
import ic2.core.network.fieldEvents.custom.PayloadFieldPacket;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCropAnalyzer
extends ItemIC2
implements IHandHeldInventory,
IDamagelessElectricItem,
ICustomNetworkItemEventListener,
ICropAnalyzer {
    public ItemCropAnalyzer() {
        this.func_77625_d(1);
        this.setUnlocalizedName(Ic2ItemLang.cropAnalyzer);
        this.setNoRepair();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        tooltip.add((StackUtil.getNbtData(stack).func_74767_n("Calculator") ? Ic2InfoLang.cropBreedMode : Ic2InfoLang.cropAnalyzeMode).getLocalized());
        List<String> ctrlTip = sortedTooltip.get((Object)ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2), Ic2InfoLang.analyzerModes));
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 43;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.platform.isSimulating() && !playerIn.func_70093_af()) {
            if (IC2.keyboard.isModeSwitchKeyDown(playerIn)) {
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
                boolean result = !nbt.func_74767_n("Calculator");
                nbt.func_74757_a("Calculator", result);
                IC2.platform.messagePlayer(playerIn, result ? Ic2InfoLang.cropBreedMode : Ic2InfoLang.cropAnalyzeMode);
            } else {
                IC2.platform.launchGui(playerIn, this.getInventory(playerIn, handIn, stack), handIn);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (StackUtil.getNbtData(stack).func_74767_n("Calculator")) {
            return new InventoryCropBreeder(player, this, stack);
        }
        return new CropAnalyzerInventory(player, this, stack);
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 50000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 1;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 100.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this, 1, 0);
        ItemStack full = new ItemStack((Item)this, 1, 0);
        ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
        ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
        items.add((Object)empty);
        items.add((Object)full);
    }

    @Override
    public void onNetworkEvent(ItemStack stack, EntityPlayer player, INetworkFieldData data) {
        if (!StackUtil.isStackEqual(stack, Ic2Items.cropAnalyzer)) {
            return;
        }
        if (!(data instanceof PayloadFieldPacket)) {
            return;
        }
        PayloadFieldPacket payload = (PayloadFieldPacket)data;
        if (player.field_71070_bA instanceof ContainerCropBreeder) {
            InventoryCropBreeder inventory = (InventoryCropBreeder)((ContainerCropBreeder)player.field_71070_bA).getGuiHolder();
            if (payload.getSize(1) < 1) {
                return;
            }
            int number = payload.getNumber(0);
            if (number == 0) {
                inventory.provided.offset(payload.getNumber(1));
            } else if (number == 1) {
                inventory.results.offset(payload.getNumber(1));
            } else if (number == 2) {
                boolean process = payload.getFlag(0);
                if (process) {
                    inventory.process();
                } else {
                    inventory.results.clear();
                }
            }
        }
    }

    @Override
    public boolean isCropAnalyzer(ItemStack stack) {
        return true;
    }
}

