/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.api.tileentity.IHeatRegistry;
import me.desht.pneumaticcraft.common.config.BlockHeatPropertiesConfig;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicConstant;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicTicking;
import me.desht.pneumaticcraft.common.heat.SimpleHeatExchanger;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourManager;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class HeatExchangerManager
implements IHeatRegistry {
    private final Map<Block, IHeatExchanger> specialBlockExchangers = new HashMap<Block, IHeatExchanger>();
    private final Map<String, IHeatExchanger> specialBlockvariantExchangers = new HashMap<String, IHeatExchanger>();
    private static final HeatExchangerManager INSTANCE = new HeatExchangerManager();

    public static HeatExchangerManager getInstance() {
        return INSTANCE;
    }

    public void onPostInit() {
        BlockHeatPropertiesConfig.INSTANCE.getCustomHeatEntries().values().forEach(this::registerCustomHeatEntry);
        Map fluids = FluidRegistry.getRegisteredFluids();
        for (Fluid fluid : fluids.values()) {
            if (fluid.getBlock() == null || this.specialBlockExchangers.containsKey(fluid.getBlock())) continue;
            BlockHeatPropertiesConfig.CustomHeatEntry entry = BlockHeatPropertiesConfig.INSTANCE.getCustomHeatEntry(fluid.getBlock().func_176223_P());
            if (entry != null) {
                this.registerBlockExchanger(fluid.getBlock(), (double)entry.getTemperature(), entry.getThermalResistance());
                continue;
            }
            Log.warning("unable to retrieve custom heat entry for fluid " + fluid.getName() + " - block: " + fluid.getBlock());
        }
        this.registerBlockExchanger((Block)Blocks.field_150356_k, this.specialBlockExchangers.get(Blocks.field_150353_l));
        this.registerBlockExchanger((Block)Blocks.field_150358_i, this.specialBlockExchangers.get(Blocks.field_150355_j));
    }

    private void registerCustomHeatEntry(BlockHeatPropertiesConfig.CustomHeatEntry rec) {
        if (rec.isDefaultState()) {
            this.registerBlockExchanger(rec.getBlockState().func_177230_c(), (double)rec.getTemperature(), rec.getThermalResistance());
        } else {
            this.registerBlockExchanger(rec.getBlockState(), (double)rec.getTemperature(), rec.getThermalResistance());
        }
    }

    public IHeatExchangerLogic getLogic(World world, BlockPos pos, EnumFacing side) {
        if (!world.func_175667_e(pos)) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IHeatExchanger) {
            return ((IHeatExchanger)te).getHeatExchangerLogic(side);
        }
        if (world.func_175623_d(pos)) {
            return HeatExchangerLogicAmbient.atPosition(world, pos);
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IHeatExchanger) {
            return ((IHeatExchanger)block).getHeatExchangerLogic(side);
        }
        IHeatExchanger exchanger = this.getSpecialBlockExchanger(state);
        return exchanger == null ? null : exchanger.getHeatExchangerLogic(side);
    }

    private IHeatExchanger getSpecialBlockExchanger(IBlockState state) {
        String key = state.func_177230_c().getRegistryName() + ":" + state.func_177230_c().func_176201_c(state);
        IHeatExchanger exchanger = this.specialBlockvariantExchangers.get(key);
        return exchanger == null ? this.specialBlockExchangers.get(state.func_177230_c()) : exchanger;
    }

    private void registerBlockExchanger(IBlockState state, IHeatExchanger heatExchanger) {
        String key;
        Block block = state.func_177230_c();
        if (block instanceof IHeatExchanger) {
            Log.warning("The block " + block.func_149739_a() + " is implementing IHeatExchanger. Therefore you don't need to register it as such");
        }
        if (this.specialBlockvariantExchangers.containsKey(key = block.getRegistryName() + ":" + block.func_176201_c(state))) {
            Log.error("The block " + key + " was registered as heat exchanger already! It won't be added!");
        } else {
            this.specialBlockvariantExchangers.put(key, heatExchanger);
        }
    }

    private void registerBlockExchanger(Block block, IHeatExchanger heatExchanger) {
        if (block == null) {
            throw new IllegalArgumentException("block is null when trying to register a heat exchanger!");
        }
        if (block instanceof IHeatExchanger) {
            Log.warning("The block " + block.func_149739_a() + " is implementing IHeatExchanger. Therefore you don't need to register it as such");
        }
        if (this.specialBlockExchangers.containsKey(block)) {
            Log.error("The block " + block.func_149739_a() + " was registered as heat exchanger already! It won't be added!");
        } else {
            this.specialBlockExchangers.put(block, heatExchanger);
        }
    }

    private void registerBlockExchanger(Block block, IHeatExchangerLogic heatExchangerLogic) {
        this.registerBlockExchanger(block, (IHeatExchanger)new SimpleHeatExchanger(heatExchangerLogic));
    }

    private void registerBlockExchanger(IBlockState state, IHeatExchangerLogic heatExchangerLogic) {
        this.registerBlockExchanger(state, (IHeatExchanger)new SimpleHeatExchanger(heatExchangerLogic));
    }

    @Override
    public void registerBlockExchanger(Block block, double temperature, double thermalResistance) {
        this.registerBlockExchanger(block, (IHeatExchangerLogic)new HeatExchangerLogicConstant(temperature, thermalResistance));
    }

    @Override
    public void registerBlockExchanger(IBlockState state, double temperature, double thermalResistance) {
        this.registerBlockExchanger(state, (IHeatExchangerLogic)new HeatExchangerLogicConstant(temperature, thermalResistance));
    }

    @Override
    public void registerHeatBehaviour(Class<? extends HeatBehaviour> heatBehaviour) {
        HeatBehaviourManager.getInstance().registerBehaviour(heatBehaviour);
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic() {
        return new HeatExchangerLogicTicking();
    }

    public static class TemperatureData {
        private final Double[] temp = new Double[7];
        private boolean isMultisided = true;

        public TemperatureData(IHeatExchanger heatExchanger) {
            Arrays.fill((Object[])this.temp, null);
            HashSet<IHeatExchangerLogic> heatExchangers = new HashSet<IHeatExchangerLogic>();
            IHeatExchangerLogic logic = null;
            for (EnumFacing face : EnumFacing.field_82609_l) {
                logic = heatExchanger.getHeatExchangerLogic(face);
                if (logic == null) continue;
                if (heatExchangers.contains(logic)) {
                    this.isMultisided = false;
                    break;
                }
                heatExchangers.add(logic);
            }
            if (this.isMultisided) {
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    logic = heatExchanger.getHeatExchangerLogic(face);
                    if (logic == null) continue;
                    this.temp[face.ordinal()] = logic.getTemperature();
                }
            } else if (logic != null) {
                this.temp[6] = logic.getTemperature();
            }
        }

        public boolean isMultisided() {
            return this.isMultisided;
        }

        public double getTemperature(EnumFacing face) {
            return face == null ? this.temp[6] : this.temp[face.ordinal()];
        }

        public boolean hasData(EnumFacing face) {
            return face == null ? this.temp[6] != null : this.temp[face.ordinal()] != null;
        }
    }
}

