/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor.pollSensors;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.universalSensor.IPollSensorSetting;
import me.desht.pneumaticcraft.common.item.Itemss;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Rectangle;

public class WorldTimeSensor
implements IPollSensorSetting {
    @Override
    public String getSensorPath() {
        return "World/Time";
    }

    @Override
    public Set<Item> getRequiredUpgrades() {
        return ImmutableSet.of((Object)Itemss.upgrades.get(IItemRegistry.EnumUpgrade.DISPENSER));
    }

    @Override
    public boolean needsTextBox() {
        return false;
    }

    @Override
    public List<String> getDescription() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(TextFormatting.BLACK + "Emits a redstone signal of which the strength is proportional to the time of the world.");
        text.add(TextFormatting.RED + "strength = time / 1500");
        text.add(TextFormatting.GREEN + "Example: If the time is 6000, the redstone strength will be 4.");
        return text;
    }

    @Override
    public int getPollFrequency(TileEntity te) {
        return 40;
    }

    @Override
    public int getRedstoneValue(World world, BlockPos pos, int sensorRange, String textBoxText) {
        return (int)(world.func_72820_D() % 24000L) / 1500;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAdditionalInfo(FontRenderer fontRenderer) {
    }

    @Override
    public Rectangle needsSlot() {
        return null;
    }
}

