/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.utils;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.squiddev.plethora.core.PlethoraCore;

public final class TypedField<O, T> {
    private static final TypedField<?, ?> NONE = new TypedField(null);
    private final Field field;

    private TypedField(Field field) {
        this.field = field;
    }

    public void set(@Nonnull O instance, @Nullable T value) {
        if (this.field == null) {
            return;
        }
        try {
            this.field.set(instance, value);
        }
        catch (LinkageError | ReflectiveOperationException e) {
            PlethoraCore.LOG.error("Unable to set {}.{}", (Object)this.field.getDeclaringClass().getName(), (Object)this.field.getName(), (Object)e);
        }
    }

    @Nullable
    public T get(@Nonnull O instance) {
        if (this.field == null) {
            return null;
        }
        try {
            Object value = this.field.get(instance);
            return (T)value;
        }
        catch (LinkageError | ReflectiveOperationException e) {
            PlethoraCore.LOG.error("Unable to get {}.{}", (Object)this.field.getDeclaringClass().getName(), (Object)this.field.getName(), (Object)e);
            return null;
        }
    }

    public static <O, T> TypedField<O, T> of(@Nonnull Class<O> type, @Nonnull String deobfField, @Nonnull String obfField) {
        try {
            Field f;
            try {
                f = type.getDeclaredField(obfField);
            }
            catch (NoSuchFieldException e) {
                f = type.getDeclaredField(deobfField);
            }
            f.setAccessible(true);
            return new TypedField<O, T>(f);
        }
        catch (NoSuchFieldException | SecurityException e) {
            PlethoraCore.LOG.error("Unable to find {}.{}", (Object)type.getName(), (Object)deobfField, (Object)e);
            TypedField<?, ?> empty = NONE;
            return empty;
        }
    }
}

