/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.redstonesignal;

import lumien.randomthings.util.NBTUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class RedstoneSignal {
    private int dimension;
    private BlockPos position;
    private int duration;
    private int age;
    private int redstoneStrength;

    public RedstoneSignal() {
    }

    public RedstoneSignal(int dimension, BlockPos position, int duration, int redstoneStrength) {
        this.dimension = dimension;
        this.position = position;
        this.duration = duration;
        this.redstoneStrength = redstoneStrength;
        this.age = 0;
    }

    public boolean tick() {
        ++this.age;
        return this.age >= this.duration;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("dimension", this.dimension);
        NBTUtil.writeBlockPosToNBT(compound, "position", this.position);
        compound.func_74768_a("redstoneStrength", this.redstoneStrength);
        compound.func_74768_a("duration", this.duration);
        compound.func_74768_a("age", this.age);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.dimension = compound.func_74762_e("dimension");
        this.position = NBTUtil.readBlockPosFromNBT(compound, "position");
        this.redstoneStrength = compound.func_74762_e("redstoneStrength");
        this.duration = compound.func_74762_e("duration");
        this.age = compound.func_74762_e("age");
    }

    public int getDimension() {
        return this.dimension;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public int getRedstoneStrength() {
        return this.redstoneStrength;
    }
}

