/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.disk;

import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskFactory;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskManager;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class StorageDiskManager
extends WorldSavedData
implements IStorageDiskManager {
    public static final String NAME = "refinedstorage_disks";
    private static final String NBT_DISKS = "Disks";
    private static final String NBT_DISK_ID = "Id";
    private static final String NBT_DISK_TYPE = "Type";
    private static final String NBT_DISK_DATA = "Data";
    private boolean canReadDisks;
    private NBTTagList disksTag;
    private ConcurrentHashMap<UUID, IStorageDisk> disks = new ConcurrentHashMap();

    public StorageDiskManager(String name) {
        super(name);
    }

    @Override
    @Nullable
    public IStorageDisk get(UUID id) {
        return this.disks.get(id);
    }

    @Override
    @Nullable
    public IStorageDisk getByStack(ItemStack disk) {
        if (!(disk.func_77973_b() instanceof IStorageDiskProvider)) {
            return null;
        }
        IStorageDiskProvider provider = (IStorageDiskProvider)disk.func_77973_b();
        if (!provider.isValid(disk)) {
            return null;
        }
        return this.get(provider.getId(disk));
    }

    @Override
    public Map<UUID, IStorageDisk> getAll() {
        return this.disks;
    }

    @Override
    public void set(UUID id, IStorageDisk disk) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (disk == null) {
            throw new IllegalArgumentException("Disk cannot be null");
        }
        if (this.disks.containsKey(id)) {
            throw new IllegalArgumentException("Disks already contains id '" + id + "'");
        }
        this.disks.put(id, disk);
    }

    @Override
    public void remove(UUID id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        this.disks.remove(id);
    }

    @Override
    public void markForSaving() {
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound tag) {
        if (tag.func_74764_b(NBT_DISKS)) {
            this.disksTag = tag.func_150295_c(NBT_DISKS, 10);
            this.canReadDisks = true;
        }
    }

    public void tryReadDisks(World world) {
        if (this.canReadDisks) {
            this.canReadDisks = false;
            for (int i = 0; i < this.disksTag.func_74745_c(); ++i) {
                NBTTagCompound diskTag = this.disksTag.func_150305_b(i);
                UUID id = diskTag.func_186857_a(NBT_DISK_ID);
                NBTTagCompound data = diskTag.func_74775_l(NBT_DISK_DATA);
                String type = diskTag.func_74779_i(NBT_DISK_TYPE);
                IStorageDiskFactory factory = API.instance().getStorageDiskRegistry().get(type);
                if (factory == null) continue;
                this.disks.put(id, factory.createFromNbt(world, data));
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        NBTTagList disks = new NBTTagList();
        for (Map.Entry<UUID, IStorageDisk> entry : this.disks.entrySet()) {
            NBTTagCompound diskTag = new NBTTagCompound();
            diskTag.func_186854_a(NBT_DISK_ID, entry.getKey());
            diskTag.func_74782_a(NBT_DISK_DATA, (NBTBase)entry.getValue().writeToNbt());
            diskTag.func_74778_a(NBT_DISK_TYPE, entry.getValue().getId());
            disks.func_74742_a((NBTBase)diskTag);
        }
        tag.func_74782_a(NBT_DISKS, (NBTBase)disks);
        return tag;
    }
}

