/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile.generator;

import java.util.Random;
import nc.block.tile.processor.BlockProcessor;
import nc.config.NCConfig;
import nc.enumm.BlockEnums;
import nc.init.NCSounds;
import nc.tile.generator.TileFissionController;
import nc.util.BlockFinder;
import nc.util.NCInventoryHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockFissionController
extends BlockProcessor {
    public final boolean isNew;

    public BlockFissionController(boolean isActive, boolean isNew) {
        super(isNew ? BlockEnums.ProcessorType.FISSION_CONTROLLER_NEW : BlockEnums.ProcessorType.FISSION_CONTROLLER, isActive);
        this.isNew = isNew;
        this.canCreatureSpawn = false;
    }

    @Override
    public void onGuiOpened(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFissionController) {
            TileFissionController controller = (TileFissionController)tile;
            controller.refreshMultiblock(true);
        }
    }

    @Override
    public void dropItems(World world, BlockPos pos, IInventory tileentity) {
        NCInventoryHelper.dropInventoryItems(world, pos, tileentity, 0, 1);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFissionController) {
            return ((TileFissionController)tile).getComparatorStrength();
        }
        return Container.func_178144_a((TileEntity)tile);
    }

    @Override
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFissionController) {
            TileFissionController controller = (TileFissionController)tile;
            BlockFinder finder = new BlockFinder(pos, world, controller.func_145832_p());
            BlockPos position = finder.randomWithin(controller.minX, controller.maxX, controller.minY, controller.maxY, controller.minZ, controller.maxZ);
            if (controller.cells <= 0) {
                return;
            }
            double soundRate = MathHelper.func_151237_a((double)0.04, (double)(Math.sqrt(controller.cells) / (double)NCConfig.fission_max_size), (double)1.0);
            if (controller.isProcessing && rand.nextDouble() < soundRate) {
                world.func_184134_a((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), NCSounds.geiger_tick, SoundCategory.BLOCKS, 1.6f, 1.0f + 0.12f * (rand.nextFloat() - 0.5f), false);
            }
        }
    }
}

