/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.init;

import cofh.CoFHCore;
import cofh.core.gui.CreativeTabCore;
import cofh.core.util.CoreUtils;
import cofh.core.util.TimeTracker;
import cofh.core.util.helpers.MathHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.ItemBlockDuct;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.item.ItemCover;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFProps;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TDProps {
    public static final int MAX_ITEMS_TRANSMITTED = 6;
    public static final int FLUID_EMPTY_UPDATE_DELAY = 96;
    public static final byte FLUID_UPDATE_DELAY = 4;
    public static final int ENDER_TRANSMIT_COST = 50;
    public static final int MAX_STUFFED_ITEMSTACKS_DROP = 30;
    public static boolean showDebugInfo = false;
    public static final String PATH_GFX = "thermaldynamics:textures/";
    public static float smallInnerModelScaling = 0.99f;
    public static float largeInnerModelScaling = 0.99f;
    public static boolean enableCoverCreativeTab = true;
    public static boolean showCoversInJEI = false;

    private TDProps() {
    }

    public static void preInit() {
        TDProps.configCommon();
        TDProps.configClient();
    }

    private static void configCommon() {
        String category = "General";
        String comment = "If TRUE, Ducts will display debug information where applicable.";
        showDebugInfo = ThermalDynamics.CONFIG.getConfiguration().getBoolean("ShowDebugInfo", category, showDebugInfo, comment);
    }

    private static void configClient() {
        String category = "Render";
        String comment = "This value affects the size of the inner duct model, such as fluids. Lower it if you experience texture z-fighting.";
        smallInnerModelScaling = MathHelper.clamp((float)((float)ThermalDynamics.CONFIG_CLIENT.get(category, "InnerModelScaling", 0.99, comment)), (float)0.5f, (float)0.99f);
        comment = "This value affects the size of the inner duct model, such as fluids, on the large (octagonal) ducts. Lower it if you experience texture z-fighting.";
        largeInnerModelScaling = MathHelper.clamp((float)((float)ThermalDynamics.CONFIG_CLIENT.get(category, "LargeInnerModelScaling", 0.99, comment)), (float)0.5f, (float)0.99f);
        category = "Interface";
        comment = "If TRUE, Thermal Dynamics Covers will have a Creative Tab. Does not work if \"Thermal Series\" Creative Tabs are in use.";
        enableCoverCreativeTab = ThermalDynamics.CONFIG_CLIENT.getConfiguration().getBoolean("ItemsInCommonTab", category, enableCoverCreativeTab, comment);
        comment = "If TRUE, Thermal Dynamics Covers will be shown in JEI.";
        showCoversInJEI = ThermalDynamics.CONFIG_CLIENT.getConfiguration().getBoolean("CoversInJEI", category, showCoversInJEI, comment);
        if (TFProps.useUnifiedTabs) {
            ThermalDynamics.tabCommon = ThermalFoundation.tabCommon;
            ThermalDynamics.tabItems = ThermalFoundation.tabItems;
            ThermalDynamics.tabUtils = ThermalFoundation.tabUtils;
            TFProps.initMiscTab();
            ThermalDynamics.tabCovers = ThermalFoundation.tabMisc;
        } else {
            ThermalDynamics.tabCommon = new CreativeTabCore("thermaldynamics"){
                int iconIndex = 0;
                TimeTracker iconTracker = new TimeTracker();

                public void updateIcon() {
                    World world = CoFHCore.proxy.getClientWorld();
                    if (CoreUtils.isClient() && this.iconTracker.hasDelayPassed(world, 80)) {
                        int next = MathHelper.RANDOM.nextInt(TDDucts.ductList.size() - 1);
                        this.iconIndex = next >= this.iconIndex ? next + 1 : next;
                        this.iconTracker.markTime(world);
                    }
                }

                @SideOnly(value=Side.CLIENT)
                public ItemStack func_78016_d() {
                    this.updateIcon();
                    return TDDucts.getDuct((int)this.iconIndex).itemStack;
                }

                @SideOnly(value=Side.CLIENT)
                public void func_78018_a(NonNullList<ItemStack> list) {
                    NonNullList stacks = NonNullList.func_191196_a();
                    super.func_78018_a(stacks);
                    for (Duct d : TDDucts.getSortedDucts()) {
                        list.add((Object)d.itemStack.func_77946_l());
                    }
                    for (ItemStack item : stacks) {
                        if (item.func_77973_b() instanceof ItemBlockDuct) continue;
                        list.add((Object)item);
                    }
                }
            };
            if (enableCoverCreativeTab) {
                ThermalDynamics.tabCovers = new CreativeTabCore("thermaldynamics", "Covers"){
                    int iconIndex = 0;
                    TimeTracker iconTracker = new TimeTracker();

                    public void updateIcon() {
                        World world = CoFHCore.proxy.getClientWorld();
                        if (CoreUtils.isClient() && this.iconTracker.hasDelayPassed(world, 80)) {
                            int next = MathHelper.RANDOM.nextInt(ItemCover.getCoverList().size() - 1);
                            this.iconIndex = next >= this.iconIndex ? next + 1 : next;
                            this.iconTracker.markTime(world);
                        }
                    }

                    @SideOnly(value=Side.CLIENT)
                    public ItemStack func_78016_d() {
                        this.updateIcon();
                        return ItemCover.getCoverList().get(this.iconIndex);
                    }
                };
            }
            ThermalDynamics.tabUtils = ThermalDynamics.tabCommon;
            ThermalDynamics.tabTools = ThermalDynamics.tabCommon;
        }
    }
}

