/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.relay;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.relay.RelayTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class GuiRelay
extends GenericGuiContainer<RelayTileEntity> {
    public static final int RELAY_WIDTH = 255;
    public static final int RELAY_HEIGHT = 148;
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private Map<String, ImageChoiceLabel> inputOutputs = new HashMap<String, ImageChoiceLabel>();
    private Map<String, TextField> energyValues = new HashMap<String, TextField>();
    private static final String[] tooltips = new String[]{"Down", "Up", "Back", "Front", "Left", "Right", "Internal (null)"};

    public GuiRelay(RelayTileEntity relayTileEntity, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)relayTileEntity, (Container)container, GuiProxy.GUI_MANUAL_MAIN, "prelay");
        this.field_146999_f = 255;
        this.field_147000_g = 148;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)new VerticalLayout());
        toplevel.addChild((Widget)this.createRedstonePanel());
        for (int i = 0; i < 7; ++i) {
            toplevel.addChild((Widget)this.createSidePanel(i));
        }
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, 255, 148));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
    }

    private Panel createRedstonePanel() {
        ImageLabel redstoneOff = (ImageLabel)new ImageLabel(this.field_146297_k, (Gui)this).setImage(iconGuiElements, 16, 0);
        ((ImageLabel)((ImageLabel)((ImageLabel)redstoneOff.setDesiredWidth(16)).setDesiredHeight(16)).setTooltips(new String[]{"Redstone signal off"})).setLayoutHint(70, 0, 16, 16);
        ImageLabel redstoneOn = (ImageLabel)new ImageLabel(this.field_146297_k, (Gui)this).setImage(iconGuiElements, 32, 0);
        ((ImageLabel)((ImageLabel)((ImageLabel)redstoneOn.setDesiredWidth(16)).setDesiredHeight(16)).setTooltips(new String[]{"Redstone signal on"})).setLayoutHint(190, 0, 16, 16);
        return (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).addChildren(new Widget[]{redstoneOff, redstoneOn});
    }

    private Panel createSidePanel(int side) {
        String labelText = String.valueOf("DUBFLRI".charAt(side));
        Label label = (Label)((Label)new Label(this.field_146297_k, (Gui)this).setText(labelText)).setTooltips(new String[]{tooltips[side]});
        ((Label)label.setDesiredWidth(14)).setDesiredHeight(14);
        return (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout().setHorizontalMargin(1)).addChild((Widget)label)).addChild((Widget)this.createSubPanel(side, "Off").setDesiredWidth(115))).addChild((Widget)this.createSubPanel(side, "On").setDesiredWidth(115));
    }

    private Panel createSubPanel(int side, String redstoneState) {
        boolean input;
        int rf;
        String labelText = String.valueOf("DUBFLRI".charAt(side));
        if ("Off".equals(redstoneState)) {
            rf = ((RelayTileEntity)this.tileEntity).getRfOff(side);
            input = ((RelayTileEntity)this.tileEntity).isInputModeOff(side);
        } else {
            rf = ((RelayTileEntity)this.tileEntity).getRfOn(side);
            input = ((RelayTileEntity)this.tileEntity).isInputModeOn(side);
        }
        ImageChoiceLabel inputOutput = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setDesiredWidth(14)).setDesiredHeight(14)).addChoice("Output", "Side set to output mode", iconGuiElements, 80, 16).addChoice("Input", "Side set to input mode", iconGuiElements, 96, 16).addChoiceEvent((parent, newChoice) -> this.changeSettings());
        String key = labelText + redstoneState;
        if (input) {
            inputOutput.setCurrentChoice("Input");
        } else {
            inputOutput.setCurrentChoice("Output");
        }
        this.inputOutputs.put(key, inputOutput);
        TextField energyField = ((TextField)((TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Amount of RF to input/output", "when redstone is " + redstoneState})).setDesiredWidth(42)).setDesiredHeight(14)).addTextEvent((parent, newText) -> this.adjustEnergy((TextField)parent, 0));
        energyField.setText(String.valueOf(rf));
        Button sub100 = this.createEnergyOffsetButton(energyField, "-", -500);
        Button add100 = this.createEnergyOffsetButton(energyField, "+", 500);
        Panel panel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout().setHorizontalMargin(1)).addChildren(new Widget[]{inputOutput, sub100, energyField, add100});
        this.energyValues.put(key, energyField);
        return panel;
    }

    private Button createEnergyOffsetButton(TextField energyField, String label, int amount) {
        return ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText(label)).setDesiredHeight(14)).setDesiredWidth(16)).addButtonEvent(parent -> this.adjustEnergy(energyField, amount));
    }

    private void adjustEnergy(TextField energyField, int amount) {
        int energy;
        try {
            energy = Integer.parseInt(energyField.getText());
        }
        catch (NumberFormatException e) {
            energy = 0;
        }
        energy = MathHelper.func_76125_a((int)(energy + amount), (int)0, (int)50000);
        energyField.setText(Integer.toString(energy));
        this.changeSettings();
    }

    private void changeSettings() {
        TypedMap.Builder builder = TypedMap.builder();
        for (int i = 0; i < 7; ++i) {
            this.addArgument(builder, i, RelayTileEntity.PARAM_INPUTON, RelayTileEntity.PARAM_RFON, "On");
            this.addArgument(builder, i, RelayTileEntity.PARAM_INPUTOFF, RelayTileEntity.PARAM_RFOFF, "Off");
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "relay.settings", builder.build());
    }

    private void addArgument(TypedMap.Builder builder, int i, List<Key<Boolean>> inputKeys, List<Key<Integer>> rfKeys, String suffix) {
        char prefix = "DUBFLRI".charAt(i);
        String key = prefix + suffix;
        int energy = Integer.parseInt(this.energyValues.get(key).getText());
        boolean input = "Input".equals(this.inputOutputs.get(key).getCurrentChoice());
        builder.put(rfKeys.get(i), (Object)energy);
        builder.put(inputKeys.get(i), (Object)input);
    }
}

