/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.recipes;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.block.machine.high.TileEntityUraniumEnricher;
import ic2.core.block.machine.low.TileEntityCompressor;
import ic2.core.block.machine.recipes.managers.BasicMachineRecipeList;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.item.recipe.AdvRecipeBase;
import ic2.core.item.recipe.entry.RecipeInputCombined;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.helpers.CompareableStack;
import ic2.core.util.misc.StackUtil;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import trinsdar.ic2c_extras.IC2CExtras;
import trinsdar.ic2c_extras.Ic2cExtrasConfig;
import trinsdar.ic2c_extras.items.ItemMiscs;
import trinsdar.ic2c_extras.items.ItemNuclearRod;
import trinsdar.ic2c_extras.items.ItemTinyDust;
import trinsdar.ic2c_extras.recipes.CraftingRecipes;
import trinsdar.ic2c_extras.recipes.GTCRecipes;
import trinsdar.ic2c_extras.recipes.MachineRecipes;
import trinsdar.ic2c_extras.recipes.ModRecipes;
import trinsdar.ic2c_extras.tileentity.TileEntityOreWashingPlant;
import trinsdar.ic2c_extras.tileentity.TileEntityThermalCentrifuge;
import trinsdar.ic2c_extras.util.Registry;

public class Ic2cExtrasRecipes {
    public static int itemQuality = 0;
    public static int dungeonWeight = 10;
    public static int netherFortressWeight = 15;
    public static int jungleTempleWeight = 15;
    public static int desertTempleWeight = 15;
    public static int strongholdWeight = 20;
    public static int tinyPlutonioumWeight = 5;
    public static IMachineRecipeList rolling = new BasicMachineRecipeList("rolling");
    public static IMachineRecipeList extruding = new BasicMachineRecipeList("extruding");
    public static IMachineRecipeList cutting = new BasicMachineRecipeList("cutting");
    public static IMachineRecipeList oreWashingPlant = new BasicMachineRecipeList("oreWashingPlant");
    public static IMachineRecipeList thermalCentrifuge = new BasicMachineRecipeList("thermalCentrifuge");
    public static Map<CompareableStack, IRecipeInput> thermalCentrifugeValidInputs = new LinkedHashMap<CompareableStack, IRecipeInput>();
    public static Map<CompareableStack, IRecipeInput> oreWashingPlantValidInputs = new LinkedHashMap<CompareableStack, IRecipeInput>();
    public static Map<CompareableStack, IRecipeInput> rollerValidInputs = new LinkedHashMap<CompareableStack, IRecipeInput>();
    public static Map<CompareableStack, IRecipeInput> extruderValidInputs = new LinkedHashMap<CompareableStack, IRecipeInput>();
    public static Map<CompareableStack, IRecipeInput> cutterValidInputs = new LinkedHashMap<CompareableStack, IRecipeInput>();

    public static String getRefinedIronCasing() {
        return IC2.config.getFlag("SteelRecipes") ? "casingSteel" : "casingRefinedIron";
    }

    public static void init() {
        CraftingRecipes.init();
        MachineRecipes.init();
        ModRecipes.init();
        Ic2cExtrasRecipes.initHarderUraniumProcessing();
        if (Ic2cExtrasConfig.autoFluidContainerRecipes) {
            MachineRecipes.initFluidFillingndEmptyingRecipes();
        }
        if (Loader.isModLoaded((String)"gtclassic")) {
            GTCRecipes.init();
        }
    }

    public static void postInit() {
        MachineRecipes.postInit();
        MachineRecipes.initMetalBenderRecipes();
        Ic2cExtrasRecipes.initInputLists();
    }

    public static void initInputLists() {
        IRecipeInput input;
        oreWashingPlantValidInputs.clear();
        thermalCentrifugeValidInputs.clear();
        rollerValidInputs.clear();
        extruderValidInputs.clear();
        cutterValidInputs.clear();
        for (IMachineRecipeList.RecipeEntry recipe : oreWashingPlant.getRecipeMap()) {
            input = recipe.getInput();
            for (ItemStack stack : input.getInputs()) {
                oreWashingPlantValidInputs.put(new CompareableStack(stack), input);
            }
        }
        for (IMachineRecipeList.RecipeEntry recipe : thermalCentrifuge.getRecipeMap()) {
            input = recipe.getInput();
            for (ItemStack stack : input.getInputs()) {
                thermalCentrifugeValidInputs.put(new CompareableStack(stack), input);
            }
        }
        for (IMachineRecipeList.RecipeEntry recipe : rolling.getRecipeMap()) {
            input = recipe.getInput();
            for (ItemStack stack : input.getInputs()) {
                rollerValidInputs.put(new CompareableStack(stack), input);
            }
        }
        for (IMachineRecipeList.RecipeEntry recipe : extruding.getRecipeMap()) {
            input = recipe.getInput();
            for (ItemStack stack : input.getInputs()) {
                extruderValidInputs.put(new CompareableStack(stack), input);
            }
        }
        for (IMachineRecipeList.RecipeEntry recipe : cutting.getRecipeMap()) {
            input = recipe.getInput();
            for (ItemStack stack : input.getInputs()) {
                cutterValidInputs.put(new CompareableStack(stack), input);
            }
        }
    }

    public static void initHarderUraniumProcessing() {
        ItemStack stoneDust = new ItemStack((Item)Registry.stoneDust);
        if (Ic2cExtrasConfig.harderUranium) {
            TileEntityUraniumEnricher.URANIUM_INGOT_REFERENCE = new ItemStack((Item)Registry.doubleEnrichedUraniumIngot);
            CommonFilters.uranFilter = new BasicItemFilter(new ItemStack((Item)Registry.doubleEnrichedUraniumIngot));
            ClassicRecipes.macerator.removeRecipe((IRecipeInput)new RecipeInputOreDict("oreUranium"));
            ClassicRecipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("oreUranium"), new ItemStack((Item)Registry.uraniumCrushedOre, 2), 1.0f, "uraniumOre");
            TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputItemStack(Ic2Items.reactorReEnrichedUraniumRod), 1500, 12000, new ItemStack((Item)Registry.plutoniumTinyDust, 2), new ItemStack((Item)Registry.thorium232TinyDust, 2), new ItemStack((Item)Registry.uranium238SmallDust, 2));
            TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack((Item)Registry.reEnrichedThorium232Cell)), 1500, 12000, new ItemStack((Item)Registry.thorium230TinyDust, 1), new ItemStack((Item)Registry.thorium232TinyDust, 1));
            TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedPurifiedUranium", 1), 900, 6000, new ItemStack((Item)Registry.uranium238, 7), new ItemStack((Item)Registry.uranium235TinyDust, 3));
            TileEntityThermalCentrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedUranium", 1), 1000, 8000, new ItemStack((Item)Registry.uranium238, 4), new ItemStack((Item)Registry.uranium235TinyDust, 1), stoneDust);
            TileEntityOreWashingPlant.addRecipe((IRecipeInput)new RecipeInputOreDict("crushedUranium", 1), 1000, new ItemStack((Item)Registry.uraniumPurifiedCrushedOre, 1), new ItemStack((Item)Registry.leadTinyDust, 2), stoneDust);
            CraftingRecipes.recipes.addRecipe(StackUtil.copyWithSize((ItemStack)Ic2Items.uraniumDrop, (int)1), new Object[]{"UUU", "TTT", "UUU", Character.valueOf('U'), "dustUranium238", Character.valueOf('T'), "dustTinyUranium235"});
            CraftingRecipes.recipes.addRecipe(new ItemStack((Item)Registry.moxFuel), new Object[]{"UUU", "TTT", "UUU", Character.valueOf('U'), "dustUranium238", Character.valueOf('T'), "dustTinyPlutonium"});
            CraftingRecipes.recipes.addRecipe(new ItemStack((Item)Registry.doubleEnrichedUraniumIngot), new Object[]{" U ", "UIU", " U ", Character.valueOf('U'), Registry.uranium238, Character.valueOf('I'), Ic2Items.uraniumIngot});
            CraftingRecipes.dustUtil("dustUranium235", new ItemStack((Item)Registry.uranium235), "dustTinyUranium235", new ItemStack((Item)Registry.uranium235TinyDust), "dustSmallUranium235", new ItemStack((Item)Registry.uranium235SmallDust));
            CraftingRecipes.dustUtil("dustUranium238", new ItemStack((Item)Registry.uranium238), "dustTinyUranium238", new ItemStack((Item)Registry.uranium238TinyDust), "dustSmallUranium238", new ItemStack((Item)Registry.uranium238SmallDust));
            CraftingRecipes.dustUtil("dustPlutonium", new ItemStack((Item)Registry.plutoniumDust), "dustTinyPlutonium", new ItemStack((Item)Registry.plutoniumTinyDust), "dustSmallPlutonium", new ItemStack((Item)Registry.plutoniumSmallDust));
            CraftingRecipes.dustUtil("dustThorium232", new ItemStack((Item)Registry.thorium232Dust), "dustTinyThorium232", new ItemStack((Item)Registry.thorium232TinyDust));
            CraftingRecipes.dustUtil("dustThorium230", new ItemStack((Item)Registry.thorium230Dust), "dustTinyThorium230", new ItemStack((Item)Registry.thorium230TinyDust));
            TileEntityCompressor.addRecipe((String)"dustPlutonium", (int)1, (ItemStack)new ItemStack((Item)Registry.plutoniumIngot));
            TileEntityCompressor.addRecipe((String)"dustThorium232", (int)1, (ItemStack)new ItemStack((Item)Registry.thorium232Ingot));
            TileEntityCompressor.addRecipe((String)"dustThorium230", (int)1, (ItemStack)new ItemStack((Item)Registry.thorium230Ingot));
            TileEntityCompressor.addRecipe((String)"crushedPurifiedUranium", (int)1, (ItemStack)Ic2Items.uraniumDrop);
            Ic2cExtrasRecipes.rodUtil(new ItemStack((Item)Registry.singleUOXCell), new ItemStack((Item)Registry.doubleUOXCell), new ItemStack((Item)Registry.quadUOXCell), ItemNuclearRod.getUran(ItemNuclearRod.NuclearRodVariants.UOX).getNewIsotopicRod(), new ItemStack((Item)Registry.reEnrichedUOXCell), new ItemStack((Item)Registry.nearDepletedUOXCell), new ItemStack((Item)Registry.oxidizedUraniumIngot));
            Ic2cExtrasRecipes.rodUtil(new ItemStack((Item)Registry.singlePlutoniumCell), new ItemStack((Item)Registry.doublePlutoniumCell), new ItemStack((Item)Registry.quadPlutoniumCell), ItemNuclearRod.getUran(ItemNuclearRod.NuclearRodVariants.PLUTONIUM).getNewIsotopicRod(), new ItemStack((Item)Registry.reEnrichedPlutoniumCell), new ItemStack((Item)Registry.nearDepletedPlutoniumCell), new ItemStack((Item)Registry.plutoniumIngot));
            Ic2cExtrasRecipes.rodUtil(new ItemStack((Item)Registry.singleMOXCell), new ItemStack((Item)Registry.doubleMOXCell), new ItemStack((Item)Registry.quadMOXCell), ItemNuclearRod.getUran(ItemNuclearRod.NuclearRodVariants.MOX).getNewIsotopicRod(), new ItemStack((Item)Registry.reEnrichedMOXCell), new ItemStack((Item)Registry.nearDepletedMOXCell), new ItemStack((Item)Registry.moxFuel));
            Ic2cExtrasRecipes.rodUtil(new ItemStack((Item)Registry.singleThorium232Cell), new ItemStack((Item)Registry.doubleThorium232Cell), new ItemStack((Item)Registry.quadThorium232Cell), ItemNuclearRod.getUran(ItemNuclearRod.NuclearRodVariants.THORIUM232).getNewIsotopicRod(), new ItemStack((Item)Registry.reEnrichedThorium232Cell), new ItemStack((Item)Registry.nearDepletedThorium232Cell), new ItemStack((Item)Registry.thorium232Ingot));
            Ic2cExtrasRecipes.rodUtil(new ItemStack((Item)Registry.singleThorium230Cell), new ItemStack((Item)Registry.doubleThorium230Cell), new ItemStack((Item)Registry.quadThorium230Cell), ItemNuclearRod.getUran(ItemNuclearRod.NuclearRodVariants.THORIUM230).getNewIsotopicRod(), new ItemStack((Item)Registry.reEnrichedThorium230Cell), new ItemStack((Item)Registry.nearDepletedThorium230Cell), new ItemStack((Item)Registry.thorium230Ingot));
            CraftingRecipes.recipes.addRecipe(new ItemStack((Block)Registry.thermoElectricGenerator), new Object[]{"DDD", "DRD", "DGD", Character.valueOf('D'), "plateDenseIron", Character.valueOf('R'), Ic2Items.nuclearReactor, Character.valueOf('G'), Ic2Items.thermalGenerator});
            CraftingRecipes.recipes.addRecipe(new ItemStack((Block)Registry.thermoElectricGeneratorMKII), new Object[]{"CIC", "CTC", "CAC", Character.valueOf('C'), Ic2cExtrasRecipes.getRefinedIronCasing(), Character.valueOf('I'), Ic2Items.iridiumPlate, Character.valueOf('T'), Registry.thermoElectricGenerator, Character.valueOf('A'), Ic2Items.advMachine});
            CraftingRecipes.recipes.addRecipe(new ItemStack((Item)Registry.plutoniumRTG), new Object[]{"IPI", "IPI", "IPI", Character.valueOf('I'), "plateDenseIron", Character.valueOf('P'), "ingotPlutonium"});
            CraftingRecipes.recipes.addRecipe(new ItemStack((Item)Registry.thoriumRTG), new Object[]{"ItI", "ITI", "ItI", Character.valueOf('I'), "plateDenseIron", Character.valueOf('t'), "ingotThorium230", Character.valueOf('T'), "ingotThorium232"});
        }
    }

    public static ItemStack getEmptyRod() {
        return Ic2cExtrasConfig.emptyNuclearRod ? new ItemStack((Item)Registry.emptyFuelRod) : Ic2Items.emptyCell;
    }

    public static void rodUtil(ItemStack single, ItemStack dual, ItemStack quad, ItemStack isotope, ItemStack reEnriched, ItemStack nearDepleted, ItemStack ingredient) {
        ItemStack emptyRod = Ic2cExtrasRecipes.getEmptyRod();
        RecipeInputCombined coal = new RecipeInputCombined(1, new IRecipeInput[]{new RecipeInputOreDict("dustCoal"), new RecipeInputOreDict("dustCharcoal")});
        CraftingRecipes.recipes.addShapelessRecipe(single, new Object[]{coal, reEnriched});
        CraftingRecipes.recipes.addRecipe(StackUtil.copyWithSize((ItemStack)nearDepleted, (int)8), new Object[]{"RRR", "RIR", "RRR", Character.valueOf('R'), emptyRod, Character.valueOf('I'), ingredient});
        CraftingRecipes.recipes.addRecipe(dual, new Object[]{"RPR", Character.valueOf('R'), single, Character.valueOf('P'), Ic2Items.denseCopperPlate});
        CraftingRecipes.recipes.addRecipe(quad, new Object[]{" R ", "PPP", " R ", Character.valueOf('R'), dual, Character.valueOf('P'), Ic2Items.denseCopperPlate});
        CraftingRecipes.recipes.addRecipe(quad, new Object[]{"RPR", "PPP", "RPR", Character.valueOf('R'), single, Character.valueOf('P'), Ic2Items.denseCopperPlate});
        CraftingRecipes.recipes.addShapelessRecipe(isotope, new Object[]{nearDepleted, coal});
        if (!IC2.config.getFlag("HardEnrichedUran")) {
            CraftingRecipes.recipes.addShapelessRecipe(single, new Object[]{emptyRod, ingredient});
            ClassicRecipes.canningMachine.registerCannerItem(emptyRod, (IRecipeInput)new RecipeInputItemStack(ingredient), single);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootFunction[] funcs = new LootFunction[]{new SetMetadata(new LootCondition[0], new RandomValueRange(0.0f, 3.0f))};
        String entryNameIridium = "ic2c_extras:iridiumshard";
        String entryNamePlutonium = "ic2c_extras:tinyplutonium";
        ItemMiscs shard = Registry.iridiumShard;
        ItemTinyDust plutonium = Registry.plutoniumTinyDust;
        if (Ic2cExtrasConfig.lootEntries) {
            if (event.getName().equals((Object)LootTableList.field_186422_d)) {
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)shard, dungeonWeight, itemQuality, funcs, new LootCondition[0], entryNameIridium));
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)plutonium, tinyPlutonioumWeight, itemQuality, funcs, new LootCondition[0], entryNamePlutonium));
            } else if (event.getName().equals((Object)LootTableList.field_186425_g)) {
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)shard, netherFortressWeight, itemQuality, funcs, new LootCondition[0], entryNameIridium));
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)plutonium, tinyPlutonioumWeight, itemQuality, funcs, new LootCondition[0], entryNamePlutonium));
            } else if (event.getName().equals((Object)LootTableList.field_186428_j) || event.getName().equals((Object)LootTableList.field_186427_i)) {
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)shard, strongholdWeight, itemQuality, funcs, new LootCondition[0], entryNameIridium));
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)plutonium, tinyPlutonioumWeight, itemQuality, funcs, new LootCondition[0], entryNamePlutonium));
            } else if (event.getName().equals((Object)LootTableList.field_186430_l)) {
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)shard, jungleTempleWeight, itemQuality, funcs, new LootCondition[0], entryNameIridium));
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)plutonium, tinyPlutonioumWeight, itemQuality, funcs, new LootCondition[0], entryNamePlutonium));
            } else if (event.getName().equals((Object)LootTableList.field_186429_k)) {
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)shard, desertTempleWeight, itemQuality, funcs, new LootCondition[0], entryNameIridium));
                event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)plutonium, tinyPlutonioumWeight, itemQuality, funcs, new LootCondition[0], entryNamePlutonium));
            }
        }
    }

    public static void removeRecipe(String modid, String recipeId) {
        ((ForgeRegistry)ForgeRegistries.RECIPES).remove(new ResourceLocation(modid, recipeId));
        Field duplicatesf = null;
        try {
            duplicatesf = AdvRecipeBase.class.getDeclaredField("duplicates");
        }
        catch (NoSuchFieldException e) {
            IC2CExtras.logger.info("Trying to access Advanced recipes has failed : (");
        }
        catch (SecurityException e) {
            IC2CExtras.logger.info("AdvRecipeBase security deployed");
        }
        if (duplicatesf != null) {
            duplicatesf.setAccessible(true);
        }
        try {
            if (duplicatesf != null) {
                ((Set)duplicatesf.get(duplicatesf)).remove(new ResourceLocation(modid, recipeId));
            }
        }
        catch (IllegalArgumentException e) {
            IC2CExtras.logger.info("Accessed AdvRecipeBase class but field getter failed");
        }
        catch (IllegalAccessException e) {
            IC2CExtras.logger.info("Accessed AdvRecipeBase class but access denied");
        }
    }
}

