/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.renderer;

import net.malisis.advert.advert.AdvertSelection;
import net.malisis.advert.advert.ClientAdvert;
import net.malisis.advert.model.ModelVariantContainer;
import net.malisis.advert.tileentity.AdvertTileEntity;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.EnumFacingUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;

public class AdvertRenderer
extends MalisisRenderer<AdvertTileEntity> {
    private ModelVariantContainer<?> container;
    private MalisisModel model;
    private Shape cube = new Cube();
    private RenderParameters rp = new RenderParameters();

    public AdvertRenderer() {
        this.registerFor(AdvertTileEntity.class);
    }

    public void render() {
        this.rp.reset();
        this.rp.rotateIcon.set((Object)false);
        if (this.tileEntity == null || ((AdvertTileEntity)this.tileEntity).getModelContainer() == null) {
            if (this.renderType == RenderType.BLOCK) {
                this.drawShape(this.cube, this.rp);
            }
            return;
        }
        this.container = ((AdvertTileEntity)this.tileEntity).getModelContainer();
        this.model = this.container.getModel().getModel();
        this.model.resetState();
        EnumFacing dir = DirectionalComponent.getDirection((IBlockState)this.blockState);
        this.model.rotate((float)(EnumFacingUtils.getRotationCount((EnumFacing)dir) * 90), 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.renderType == RenderType.BLOCK) {
            this.container.renderBlock(this, (AdvertTileEntity)this.tileEntity, this.rp);
            return;
        }
        if (this.renderType == RenderType.TILE_ENTITY) {
            this.container.renderTileEntity(this, (AdvertTileEntity)this.tileEntity, this.rp);
        }
    }

    public void renderAdvertFace(Face face, AdvertSelection as) {
        this.renderAdvertFace(face, as, as != null ? as.getIcon() : null);
    }

    public void renderAdvertFace(Face face, AdvertSelection as, Icon icon) {
        ClientAdvert advert = null;
        if (as != null && (advert = as.getAdvert()) == null && !ClientAdvert.isPending()) {
            ((AdvertTileEntity)this.tileEntity).addSelection(0, null);
        }
        this.rp.applyTexture.set((Object)false);
        if (advert != null && advert.getTexture() != null) {
            this.func_147499_a(advert.getTexture().getResourceLocation());
        } else {
            this.func_147499_a(this.container.getModel().getPlaceHolder());
            this.rp.icon.set(null);
        }
        face.setTexture(icon);
        this.drawFace(face, this.rp);
        this.next();
    }
}

