/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator;

import ic2.core.IC2;
import ic2.core.block.base.BlockMultiID;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.generator.tile.TileEntityLVRFProducer;
import ic2.core.block.generator.tile.TileEntitySolarPanel;
import ic2.core.block.generator.tile.TileEntityWaterGenerator;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCompactedGenerator
extends BlockMultiID
implements IBootable {
    public BlockCompactedGenerator() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setUnlocalizedName(Ic2BlockLang.compactedGenerator);
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public void onLoad() {
        Ic2Items.lvSolarPanel = new ItemStack((Block)this, 1, 0);
        Ic2Items.mvSolarPanel = new ItemStack((Block)this, 1, 1);
        Ic2Items.hvSolarPanel = new ItemStack((Block)this, 1, 2);
        Ic2Items.lvWaterMill = new ItemStack((Block)this, 1, 3);
        Ic2Items.mvWaterMill = new ItemStack((Block)this, 1, 4);
        Ic2Items.hvWaterMill = new ItemStack((Block)this, 1, 5);
        Ic2Items.lvRFProducer = new ItemStack((Block)this, 1, 6);
        Ic2Items.mvRFProducer = new ItemStack((Block)this, 1, 7);
        Ic2Items.hvRFProducer = new ItemStack((Block)this, 1, 8);
        Ic2States.lvSolarPanel = this.func_176203_a(0);
        Ic2States.mvSolarPanel = this.func_176203_a(1);
        Ic2States.hvSolarPanel = this.func_176203_a(2);
        Ic2States.lvWaterMill = this.func_176203_a(3);
        Ic2States.mvWaterMill = this.func_176203_a(4);
        Ic2States.hvWaterMill = this.func_176203_a(5);
        Ic2States.lvRFProducer = this.func_176203_a(6);
        Ic2States.mvRFProducer = this.func_176203_a(7);
        Ic2States.hvRFProducer = this.func_176203_a(8);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainerIC2((Block)this, new IProperty[]{this.getMetadataProperty(), active, allFacings});
    }

    @Deprecated
    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        int meta = this.func_176201_c(state);
        if (meta >= 0 && meta <= 2) {
            return false;
        }
        return super.func_189872_a(state, entityIn);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public List<IBlockState> getValidStates() {
        return this.func_176194_O().func_177619_a();
    }

    @Override
    public List<IBlockState> getValidStateList() {
        IBlockState def = this.func_176223_P();
        ArrayList<IBlockState> state = new ArrayList<IBlockState>();
        for (int meta : this.getValidMetas()) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                state.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)allFacings, (Comparable)side));
                state.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)allFacings, (Comparable)side));
            }
        }
        return state;
    }

    @Override
    public TileEntityBlock createNewTileEntity(World worldIn, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntitySolarPanel.TileEntityLVSolarPanel();
            }
            case 1: {
                return new TileEntitySolarPanel.TileEntityMVSolarPanel();
            }
            case 2: {
                return new TileEntitySolarPanel.TileEntityHVSolarPanel();
            }
            case 3: {
                return new TileEntityWaterGenerator.TileEntityLVWaterGen();
            }
            case 4: {
                return new TileEntityWaterGenerator.TileEntityMVWaterGen();
            }
            case 5: {
                return new TileEntityWaterGenerator.TileEntityHVWaterGen();
            }
            case 6: {
                return new TileEntityLVRFProducer();
            }
            case 7: {
                return new TileEntityLVRFProducer.TileEntityMVRFProducer();
            }
            case 8: {
                return new TileEntityLVRFProducer.TileEntityHVRFProducer();
            }
        }
        return null;
    }

    @Override
    public List<Integer> getValidMetas() {
        return Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite[] getIconSheet(int meta) {
        return Ic2Icons.getTextures("bgenComp");
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int amount;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (placer instanceof EntityPlayer && (amount = this.getCount(state)) > 0) {
            IC2.achievements.issueStat((EntityPlayer)placer, "cleanEnergy", amount);
        }
    }

    @Override
    public EnumFacing getDefaultPlacementFacing(IBlockState state, EntityLivingBase placer) {
        int meta = this.func_176201_c(state);
        if (meta >= 6 && meta <= 8) {
            int pitch = Math.round(placer.field_70125_A);
            if (pitch >= 65) {
                return EnumFacing.UP;
            }
            if (pitch <= -65) {
                return EnumFacing.DOWN;
            }
            return super.getDefaultPlacementFacing(state, placer);
        }
        return super.getDefaultPlacementFacing(state, placer);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        int amount = this.getCount(state);
        if (amount > 0) {
            IC2.achievements.issueStat(player, "dirtyEnergy", amount);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    @Override
    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        int amount = this.getCount(state);
        if (amount > 0) {
            IC2.achievements.issueStat(player, "dirtyEnergy", amount);
        }
        return super.getWrenchDrops(world, pos, state, te, player, fortune);
    }

    public int getCount(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 0: {
                return 8;
            }
            case 1: {
                return 64;
            }
            case 2: {
                return 512;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 64;
            }
            case 5: {
                return 512;
            }
        }
        return 0;
    }

    @Override
    public boolean needsRedstoneUpdates(int meta) {
        return meta >= 6 && meta <= 8;
    }
}

