/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.subtile.SubTileEntity;

@SideOnly(value=Side.CLIENT)
public final class BotaniaAPIClient {
    private static final Map<String, ModelResourceLocation> subtileBlockModels = Maps.newHashMap();
    private static final Map<String, ModelResourceLocation> subtileItemModels = Maps.newHashMap();
    private static final Map<IFloatingFlower.IslandType, ModelResourceLocation> islandTypeModels = Maps.newHashMap();

    private BotaniaAPIClient() {
    }

    public static void registerSubtileModel(String subTileName, ModelResourceLocation model, ModelResourceLocation itemModel) {
        subtileBlockModels.put(subTileName, model);
        subtileItemModels.put(subTileName, itemModel);
    }

    public static void registerSubtileModel(String subTileName, ModelResourceLocation model) {
        BotaniaAPIClient.registerSubtileModel(subTileName, model, new ModelResourceLocation(model.func_110624_b() + ":" + model.func_110623_a(), "inventory"));
    }

    public static void registerSubtileModel(Class<? extends SubTileEntity> clazz, ModelResourceLocation model) {
        BotaniaAPIClient.registerSubtileModel(BotaniaAPI.getSubTileStringMapping(clazz), model);
    }

    public static void registerSubtileModel(Class<? extends SubTileEntity> clazz, ModelResourceLocation model, ModelResourceLocation itemModel) {
        BotaniaAPIClient.registerSubtileModel(BotaniaAPI.getSubTileStringMapping(clazz), model, itemModel);
    }

    public static Map<String, ModelResourceLocation> getRegisteredSubtileBlockModels() {
        return Collections.unmodifiableMap(subtileBlockModels);
    }

    public static Map<String, ModelResourceLocation> getRegisteredSubtileItemModels() {
        return Collections.unmodifiableMap(subtileItemModels);
    }

    public static void registerIslandTypeModel(IFloatingFlower.IslandType islandType, ModelResourceLocation model) {
        islandTypeModels.put(islandType, model);
    }

    public static Map<IFloatingFlower.IslandType, ModelResourceLocation> getRegisteredIslandTypeModels() {
        return Collections.unmodifiableMap(islandTypeModels);
    }
}

