/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.IItemHandler;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.recipe.RecipeBrew;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.handler.ModSounds;

public class TileBrewery
extends TileSimpleInventory
implements IManaReceiver,
ITickable {
    private static final String TAG_MANA = "mana";
    private static final int CRAFT_EFFECT_EVENT = 0;
    public RecipeBrew recipe;
    int mana = 0;
    int manaLastTick = 0;
    public int signal = 0;

    public boolean addItem(@Nullable EntityPlayer player, ItemStack stack, @Nullable EnumHand hand) {
        if (this.recipe != null || stack.func_190926_b() || stack.func_77973_b() instanceof IBrewItem && ((IBrewItem)stack.func_77973_b()).getBrew(stack) != null && ((IBrewItem)stack.func_77973_b()).getBrew(stack) != BotaniaAPI.fallbackBrew || this.itemHandler.getStackInSlot(0).func_190926_b() != stack.func_77973_b() instanceof IBrewContainer) {
            return false;
        }
        boolean did = false;
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (!this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            did = true;
            ItemStack stackToAdd = stack.func_77946_l();
            stackToAdd.func_190920_e(1);
            this.itemHandler.setStackInSlot(i, stackToAdd);
            if (player != null && player.field_71075_bZ.field_75098_d) break;
            stack.func_190918_g(1);
            if (!stack.func_190926_b() || player == null) break;
            player.func_184611_a(hand, ItemStack.field_190927_a);
            break;
        }
        if (did) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
            for (RecipeBrew recipe : BotaniaAPI.brewRecipes) {
                if (!recipe.matches((IItemHandler)this.itemHandler) || recipe.getOutput(this.itemHandler.getStackInSlot(0)).func_190926_b()) continue;
                this.recipe = recipe;
                this.field_145850_b.func_180501_a(this.field_174879_c, ModBlocks.brewery.func_176223_P().func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
        return true;
    }

    public void func_73660_a() {
        if (this.mana > 0 && this.recipe == null) {
            for (RecipeBrew recipeBrew : BotaniaAPI.brewRecipes) {
                if (!recipeBrew.matches((IItemHandler)this.itemHandler)) continue;
                this.recipe = recipeBrew;
                this.field_145850_b.func_180501_a(this.field_174879_c, ModBlocks.brewery.func_176223_P().func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(true)), 3);
            }
            if (this.recipe == null) {
                this.mana = 0;
            }
        }
        this.recieveMana(0);
        if (!this.field_145850_b.field_72995_K && this.recipe == null) {
            List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)));
            for (EntityItem item : items) {
                if (item.field_70128_L || item.func_92059_d().func_190926_b()) continue;
                ItemStack stack = item.func_92059_d();
                this.addItem(null, stack, null);
            }
        }
        if (this.recipe != null) {
            if (!this.recipe.matches((IItemHandler)this.itemHandler)) {
                this.recipe = null;
                this.field_145850_b.func_180501_a(this.field_174879_c, ModBlocks.brewery.func_176223_P(), 3);
            }
            if (this.recipe != null) {
                if (this.mana != this.manaLastTick) {
                    Color color = new Color(this.recipe.getBrew().getColor(this.itemHandler.getStackInSlot(0)));
                    float f = (float)color.getRed() / 255.0f;
                    float g = (float)color.getGreen() / 255.0f;
                    float b = (float)color.getBlue() / 255.0f;
                    for (int i = 0; i < 5; ++i) {
                        Botania.proxy.wispFX((double)this.field_174879_c.func_177958_n() + 0.7 - Math.random() * 0.4, (double)this.field_174879_c.func_177956_o() + 0.9 - Math.random() * 0.2, (double)this.field_174879_c.func_177952_p() + 0.7 - Math.random() * 0.4, f, g, b, 0.1f + (float)Math.random() * 0.05f, 0.03f - (float)Math.random() * 0.06f, 0.03f + (float)Math.random() * 0.015f, 0.03f - (float)Math.random() * 0.06f);
                        for (int j = 0; j < 2; ++j) {
                            Botania.proxy.wispFX((double)this.field_174879_c.func_177958_n() + 0.7 - Math.random() * 0.4, (double)this.field_174879_c.func_177956_o() + 0.9 - Math.random() * 0.2, (double)this.field_174879_c.func_177952_p() + 0.7 - Math.random() * 0.4, 0.2f, 0.2f, 0.2f, 0.1f + (float)Math.random() * 0.2f, 0.03f - (float)Math.random() * 0.06f, 0.03f + (float)Math.random() * 0.015f, 0.03f - (float)Math.random() * 0.06f);
                        }
                    }
                }
                if (this.mana >= this.getManaCost() && !this.field_145850_b.field_72995_K) {
                    int mana = this.getManaCost();
                    this.recieveMana(-mana);
                    ItemStack itemStack = this.recipe.getOutput(this.itemHandler.getStackInSlot(0));
                    EntityItem outputItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, itemStack);
                    this.field_145850_b.func_72838_d((Entity)outputItem);
                    this.field_145850_b.func_175641_c(this.func_174877_v(), ModBlocks.brewery, 0, this.recipe.getBrew().getColor(itemStack));
                    for (int i = 0; i < this.getSizeInventory(); ++i) {
                        this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                }
            }
        }
        int newSignal = 0;
        if (this.recipe != null) {
            ++newSignal;
        }
        if (newSignal != this.signal) {
            this.signal = newSignal;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
        }
        this.manaLastTick = this.mana;
    }

    public boolean func_145842_c(int event, int param) {
        if (event == 0) {
            if (this.field_145850_b.field_72995_K) {
                for (int i = 0; i < 25; ++i) {
                    Color c = new Color(param);
                    float r = (float)c.getRed() / 255.0f;
                    float g = (float)c.getGreen() / 255.0f;
                    float b = (float)c.getBlue() / 255.0f;
                    Botania.proxy.sparkleFX((double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, r, g, b, (float)Math.random() * 2.0f + 0.5f, 10);
                    for (int j = 0; j < 2; ++j) {
                        Botania.proxy.wispFX((double)this.field_174879_c.func_177958_n() + 0.7 - Math.random() * 0.4, (double)this.field_174879_c.func_177956_o() + 0.9 - Math.random() * 0.2, (double)this.field_174879_c.func_177952_p() + 0.7 - Math.random() * 0.4, 0.2f, 0.2f, 0.2f, 0.1f + (float)Math.random() * 0.2f, 0.05f - (float)Math.random() * 0.1f, 0.05f + (float)Math.random() * 0.03f, 0.05f - (float)Math.random() * 0.1f);
                    }
                }
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ModSounds.potionCreate, SoundCategory.BLOCKS, 1.0f, 1.5f + (float)Math.random() * 0.25f, false);
            }
            return true;
        }
        return super.func_145842_c(event, param);
    }

    public int getManaCost() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (this.recipe == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof IBrewContainer)) {
            return 0;
        }
        IBrewContainer container = (IBrewContainer)stack.func_77973_b();
        return container.getManaCost(this.recipe.getBrew(), stack);
    }

    @Override
    public void writePacketNBT(NBTTagCompound par1nbtTagCompound) {
        super.writePacketNBT(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(NBTTagCompound par1nbtTagCompound) {
        super.readPacketNBT(par1nbtTagCompound);
        this.mana = par1nbtTagCompound.func_74762_e(TAG_MANA);
    }

    @Override
    public int getSizeInventory() {
        return 7;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler(this, false){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }
        };
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.getManaCost();
    }

    @Override
    public void recieveMana(int mana) {
        this.mana = Math.min(this.mana + mana, this.getManaCost());
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return !this.isFull();
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        int manaToGet = this.getManaCost();
        if (manaToGet > 0) {
            int x = res.func_78326_a() / 2 + 20;
            int y = res.func_78328_b() / 2 - 8;
            if (this.recipe == null) {
                return;
            }
            RenderHelper.renderProgressPie(x, y, (float)this.mana / (float)manaToGet, this.recipe.getOutput(this.itemHandler.getStackInSlot(0)));
        }
    }
}

