/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetCoordinate;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProgWidgetCoordinate
extends ProgWidget
implements IVariableWidget {
    private int x;
    private int y;
    private int z;
    private String variable = "";
    private boolean useVariable;
    private DroneAIManager aiManager;

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return ProgWidgetCoordinate.class;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetCoordinate.class};
    }

    @Override
    public void addWarnings(List<String> curInfo, List<IProgWidget> widgets) {
        super.addWarnings(curInfo, widgets);
        if (!this.useVariable && this.x == 0 && this.y == 0 && this.z == 0) {
            curInfo.add("gui.progWidget.coordinate.warning.noCoordinate");
        }
    }

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.useVariable && this.variable.equals("")) {
            curInfo.add("gui.progWidget.general.error.emptyVariable");
        }
    }

    @Override
    public String getWidgetString() {
        return "coordinate";
    }

    @Override
    public int getCraftingColorIndex() {
        return 2;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_COORDINATE;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("posX", this.x);
        tag.func_74768_a("posY", this.y);
        tag.func_74768_a("posZ", this.z);
        tag.func_74778_a("variable", this.variable);
        tag.func_74757_a("useVariable", this.useVariable);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.x = tag.func_74762_e("posX");
        this.y = tag.func_74762_e("posY");
        this.z = tag.func_74762_e("posZ");
        this.variable = tag.func_74779_i("variable");
        this.useVariable = tag.func_74767_n("useVariable");
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    public BlockPos getCoordinate() {
        if (this.useVariable && this.aiManager != null) {
            return this.aiManager.getCoordinate(this.variable);
        }
        return this.getRawCoordinate();
    }

    public BlockPos getRawCoordinate() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public void setCoordinate(BlockPos pos) {
        if (pos != null) {
            this.x = pos.func_177958_n();
            this.y = pos.func_177956_o();
            this.z = pos.func_177952_p();
        } else {
            this.z = 0;
            this.y = 0;
            this.x = 0;
        }
    }

    public void setVariable(String varName) {
        this.variable = varName;
    }

    public String getVariable() {
        return this.variable;
    }

    public boolean isUsingVariable() {
        return this.useVariable;
    }

    public void setUsingVariable(boolean useVariable) {
        this.useVariable = useVariable;
    }

    public void loadFromGPSTool(ItemStack gpsTool) {
        String variable = ItemGPSTool.getVariable(gpsTool);
        if ("".equals(variable)) {
            this.setCoordinate(ItemGPSTool.getGPSLocation(gpsTool));
            this.setUsingVariable(false);
        } else {
            this.setVariable("#" + variable);
            this.setUsingVariable(true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetCoordinate(this, guiProgrammer);
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.useVariable) {
            curTooltip.add("XYZ: \"" + this.variable + "\"");
        } else if (this.x != 0 || this.y != 0 || this.z != 0) {
            curTooltip.add("X: " + this.x + ", Y: " + this.y + ", Z: " + this.z);
        }
    }

    @Override
    public String getExtraStringInfo() {
        if (this.useVariable) {
            return "\"" + this.variable + "\"";
        }
        return this.x != 0 || this.y != 0 || this.z != 0 ? this.x + ", " + this.y + ", " + this.z : null;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }
}

