/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.astralsorcery;

import dan200.computercraft.api.lua.LuaException;
import hellfirepvp.astralsorcery.common.auxiliary.CelestialGatewaySystem;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.data.world.data.GatewayCache;
import hellfirepvp.astralsorcery.common.tile.TileCelestialGateway;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.api.method.wrapper.FromSubtarget;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.integration.EntityIdentifier;

public final class MethodsAstralSorcery {
    private MethodsAstralSorcery() {
    }

    @PlethoraMethod(modId="astralsorcery", doc="-- Get a list of all Celestial Gateways, grouped by dimension")
    public static Map<String, ?> getGateways(@FromTarget TileCelestialGateway gateway) {
        Map nodesByDimension = CelestialGatewaySystem.instance.getGatewayCache(Side.SERVER);
        HashMap fullOut = new HashMap(nodesByDimension.size());
        for (Map.Entry entry : nodesByDimension.entrySet()) {
            List dimNodes = (List)entry.getValue();
            LuaList dimOut = new LuaList(dimNodes.size());
            for (GatewayCache.GatewayNode node : dimNodes) {
                HashMap<String, Object> inner = new HashMap<String, Object>(4);
                inner.put("posX", node.func_177958_n());
                inner.put("posY", node.func_177956_o());
                inner.put("posZ", node.func_177952_p());
                inner.put("name", node.display);
                dimOut.add(inner);
            }
            fullOut.put(String.valueOf(entry.getKey()), dimOut.asMap());
        }
        return fullOut;
    }

    @PlethoraMethod(modId="astralsorcery", module={"plethora:introspection"}, doc="-- Get this player's progress in Astral Sorcery")
    public static Map<String, ?> getAstralProgress(@Nonnull IContext<IModuleContainer> context, @FromSubtarget EntityIdentifier.Player playerId) throws LuaException {
        EntityPlayerMP player = playerId.getPlayer();
        HashMap<String, Object> out = new HashMap<String, Object>();
        PlayerProgress progress = ResearchManager.getProgress((EntityPlayer)player);
        out.put("seenConstellations", MethodsAstralSorcery.getConstellationMeta(context, progress.getSeenConstellations()));
        out.put("knownConstellations", MethodsAstralSorcery.getConstellationMeta(context, progress.getKnownConstellations()));
        out.put("availablePerkPoints", progress.getAvailablePerkPoints((EntityPlayer)player));
        IMajorConstellation attuned = progress.getAttunedConstellation();
        if (attuned != null) {
            out.put("attunedConstellation", context.makePartialChild(attuned).getMeta());
        }
        out.put("progressTier", progress.getTierReached().toString());
        String researchTier = progress.getResearchProgression().stream().max(Comparator.comparingInt(ResearchProgression::getProgressId)).map(Enum::toString).orElse(null);
        if (researchTier != null) {
            out.put("researchTier", researchTier);
        }
        return out;
    }

    @Nonnull
    private static Map<Integer, TypedMeta<IConstellation, ?>> getConstellationMeta(IContext<?> context, Collection<String> translationKeys) {
        LuaList out = new LuaList(translationKeys.size());
        for (String translationKey : translationKeys) {
            IConstellation constellation = ConstellationRegistry.getConstellationByName((String)translationKey);
            if (constellation == null) continue;
            out.add(context.makePartialChild(constellation).getMeta());
        }
        return out.asMap();
    }
}

