/*
 * Decompiled with CFR 0.152.
 */
package sonar.core;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sonar.core.SonarCore;
import sonar.core.common.block.StableStone;

public class SonarCrafting
extends SonarCore {
    private static int recipeNumber;

    public static void registerCraftingRecipes() {
        ResourceLocation group = new ResourceLocation("SonarCore");
        SonarCrafting.addShapeless("sonarcore", group, new ItemStack(SonarCore.reinforcedStoneBrick, 2), SonarCrafting.fromBlock(SonarCore.reinforcedStoneBlock), SonarCrafting.fromBlock(SonarCore.reinforcedStoneBlock));
        SonarCrafting.addShapeless("sonarcore", group, new ItemStack(SonarCore.stableStone[0], 2), SonarCrafting.fromBlock(SonarCore.reinforcedStoneBrick), SonarCrafting.fromBlock(SonarCore.reinforcedStoneBrick));
        SonarCrafting.addShapeless("sonarcore", group, new ItemStack(SonarCore.stableGlass, 1), SonarCrafting.fromBlock(SonarCore.clearStableGlass));
        SonarCrafting.addShapeless("sonarcore", group, new ItemStack(SonarCore.clearStableGlass, 1), SonarCrafting.fromBlock(SonarCore.stableGlass));
        SonarCrafting.addShaped("sonarcore", group, new ItemStack(SonarCore.reinforcedStoneStairs, 4), "A  ", "AA ", "AAA", Character.valueOf('A'), SonarCore.reinforcedStoneBlock);
        SonarCrafting.addShaped("sonarcore", group, new ItemStack(SonarCore.reinforcedStoneBrickStairs, 4), "A  ", "AA ", "AAA", Character.valueOf('A'), SonarCore.reinforcedStoneBrick);
        SonarCrafting.addShaped("sonarcore", group, new ItemStack(SonarCore.reinforcedDirtStairs, 4), "A  ", "AA ", "AAA", Character.valueOf('A'), SonarCore.reinforcedDirtBlock);
        SonarCrafting.addShaped("sonarcore", group, new ItemStack(SonarCore.reinforcedDirtBrickStairs, 4), "A  ", "AA ", "AAA", Character.valueOf('A'), SonarCore.reinforcedDirtBrick);
        SonarCrafting.addShapedOre("sonarcore", new ItemStack(SonarCore.reinforcedStoneFence, 6), "ASA", "ASA", Character.valueOf('A'), SonarCore.reinforcedStoneBlock, Character.valueOf('S'), "stickWood");
        SonarCrafting.addShapedOre("sonarcore", new ItemStack(SonarCore.reinforcedStoneBrickFence, 6), "ASA", "ASA", Character.valueOf('A'), SonarCore.reinforcedStoneBrick, Character.valueOf('S'), "stickWood");
        SonarCrafting.addShapedOre("sonarcore", new ItemStack(SonarCore.reinforcedDirtFence, 6), "ASA", "ASA", Character.valueOf('A'), SonarCore.reinforcedDirtBlock, Character.valueOf('S'), "stickWood");
        SonarCrafting.addShapedOre("sonarcore", new ItemStack(SonarCore.reinforcedDirtBrickFence, 6), "ASA", "ASA", Character.valueOf('A'), SonarCore.reinforcedDirtBrick, Character.valueOf('S'), "stickWood");
        SonarCrafting.addShapedOre("sonarcore", new ItemStack(SonarCore.reinforcedStoneGate, 1), "SAS", "SAS", Character.valueOf('A'), SonarCore.reinforcedStoneBlock, Character.valueOf('S'), "stickWood");
        SonarCrafting.addShapedOre("sonarcore", new ItemStack(SonarCore.reinforcedStoneBrickGate, 1), "SAS", "SAS", Character.valueOf('A'), SonarCore.reinforcedStoneBrick, Character.valueOf('S'), "stickWood");
        SonarCrafting.addShapedOre("sonarcore", new ItemStack(SonarCore.reinforcedDirtGate, 1), "SAS", "SAS", Character.valueOf('A'), SonarCore.reinforcedDirtBlock, Character.valueOf('S'), "stickWood");
        SonarCrafting.addShapedOre("sonarcore", new ItemStack(SonarCore.reinforcedDirtBrickGate, 1), "SAS", "SAS", Character.valueOf('A'), SonarCore.reinforcedDirtBrick, Character.valueOf('S'), "stickWood");
        for (int i = 0; i < 16; ++i) {
            SonarCrafting.addShaped("sonarcore", group, new ItemStack(SonarCore.stableStone[i], 8), "SSS", "SDS", "SSS", Character.valueOf('D'), new ItemStack(Items.field_151100_aR, 1, StableStone.Variants.values()[i].getDyeMeta()), Character.valueOf('S'), new ItemStack(SonarCore.stableStone[0], 1));
            SonarCrafting.addShapeless("sonarcore", group, new ItemStack(stablestonerimmedBlock[i], 1), SonarCrafting.fromBlock(stableStone[i]));
            SonarCrafting.addShapeless("sonarcore", group, new ItemStack(stablestonerimmedblackBlock[i], 1), SonarCrafting.fromBlock(stablestonerimmedBlock[i]));
            SonarCrafting.addShapeless("sonarcore", group, new ItemStack(SonarCore.stableStone[i], 1), SonarCrafting.fromBlock(SonarCore.stablestonerimmedblackBlock[i]));
        }
        if (!Loader.isModLoaded((String)"calculator")) {
            SonarCrafting.addShapelessOre("sonarcore", new ItemStack(SonarCore.reinforcedStoneBlock, 1), "cobblestone", "plankWood");
            SonarCrafting.addShapelessOre("sonarcore", new ItemStack(SonarCore.reinforcedStoneBlock, 4), "cobblestone", "logWood");
            SonarCrafting.addShapelessOre("sonarcore", new ItemStack(SonarCore.reinforcedDirtBlock, 1), Blocks.field_150346_d, "plankWood");
            SonarCrafting.addShapelessOre("sonarcore", new ItemStack(SonarCore.reinforcedDirtBlock, 4), Blocks.field_150346_d, "logWood");
            SonarCrafting.addShapelessOre("sonarcore", new ItemStack(SonarCore.stableGlass, 2), "blockGlass", "blockGlass");
            SonarCrafting.addShapeless("sonarcore", group, new ItemStack(SonarCore.reinforcedDirtBrick, 2), SonarCrafting.fromBlock(SonarCore.reinforcedDirtBlock), SonarCrafting.fromBlock(SonarCore.reinforcedDirtBlock));
        }
    }

    public static Ingredient fromBlock(Block b) {
        return Ingredient.func_193367_a((Item)Item.func_150898_a((Block)b));
    }

    public static void addShaped(String modid, ResourceLocation group, ItemStack result, Object ... input) {
        if (!result.func_190926_b() && input != null) {
            try {
                GameRegistry.addShapedRecipe((ResourceLocation)SonarCrafting.getRecipeResourceLocation(modid, result), (ResourceLocation)group, (ItemStack)result, (Object[])input);
            }
            catch (Exception exception) {
                logger.error("ERROR ADDING SHAPED RECIPE: " + result);
                exception.printStackTrace();
            }
        }
    }

    public static void addShapedOre(String modid, ItemStack result, Object ... input) {
        if (!result.func_190926_b() && input != null) {
            try {
                ResourceLocation r = SonarCrafting.getRecipeResourceLocation(modid, result);
                ShapedOreRecipe oreRecipe = new ShapedOreRecipe(r, result, input);
                oreRecipe.setRegistryName(r);
                ForgeRegistries.RECIPES.register((IForgeRegistryEntry)oreRecipe);
            }
            catch (Exception exception) {
                logger.error("ERROR ADDING SHAPED ORE RECIPE: " + result);
                exception.printStackTrace();
            }
        }
    }

    public static void addShapeless(String modid, ResourceLocation group, ItemStack result, Ingredient ... input) {
        if (!result.func_190926_b() && input != null) {
            try {
                GameRegistry.addShapelessRecipe((ResourceLocation)SonarCrafting.getRecipeResourceLocation(modid, result), (ResourceLocation)group, (ItemStack)result, (Ingredient[])input);
            }
            catch (Exception exception) {
                logger.error("ERROR ADDING SHAPELESS RECIPE: " + result);
                exception.printStackTrace();
            }
        }
    }

    public static void addShapelessOre(String modid, ItemStack result, Object ... input) {
        if (!result.func_190926_b() && input != null) {
            try {
                ResourceLocation r = SonarCrafting.getRecipeResourceLocation(modid, result);
                ShapelessOreRecipe oreRecipe = new ShapelessOreRecipe(r, result, input);
                oreRecipe.setRegistryName(r);
                ForgeRegistries.RECIPES.register((IForgeRegistryEntry)oreRecipe);
            }
            catch (Exception exception) {
                logger.error("ERROR ADDING SHAPELESS ORE RECIPE: " + result);
                exception.printStackTrace();
            }
        }
    }

    public static void registerForgeRecipe(ResourceLocation location, IRecipe recipe) {
        try {
            recipe.setRegistryName(location);
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
        }
        catch (Exception exception) {
            logger.error("ERROR ADDING ABSTRACT FORGE RECIPE: " + location);
            exception.printStackTrace();
        }
    }

    public static ResourceLocation getRecipeResourceLocation(String modid, ItemStack result) {
        return new ResourceLocation(modid, result.func_77977_a() + recipeNumber++);
    }
}

