/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview;

import java.awt.Color;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import pregenerator.ConfigManager;
import pregenerator.base.impl.gui.GuiPregenBase;
import pregenerator.base.impl.gui.GuiSlider;
import pregenerator.base.impl.misc.SelectionList;
import pregenerator.impl.client.preview.GuiKeepWorld;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.data.MapManager;
import pregenerator.impl.client.preview.data.SubProcessor;
import pregenerator.impl.client.preview.texture.MoveableTexture;
import pregenerator.impl.client.preview.world.CustomServer;
import pregenerator.impl.client.preview.world.WorldInstance;
import pregenerator.impl.client.preview.world.WorldSeed;
import pregenerator.impl.client.preview.world.data.IChunkData;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkProcessor;
import pregenerator.impl.storage.TaskStorage;

public class GuiSeedPreview
extends GuiPregenBase
implements GuiSlider.ISlider {
    public static final Color SLIME_COLOR = new Color(0, 255, 255, 128);
    public static final DecimalFormat BIG_FORMAT = new DecimalFormat("###,###");
    WorldSeed seed;
    Map<Integer, WorldInstance> dimensions = new ConcurrentHashMap<Integer, WorldInstance>();
    SelectionList<Integer> allDimensions = new SelectionList();
    SelectionList<String> mapViews = new SelectionList<String>(Arrays.asList("Block Colors", "Biome(Foliage) Colors", "Biome(Grass) Colors"));
    GuiTextField seedName;
    boolean terrainOnly = true;
    boolean slimeChunks = false;
    boolean structures = false;
    public MapManager mapData = new MapManager();
    SubProcessor processor = new SubProcessor();
    CustomServer fakeServer = null;
    MoveableTexture displayTexture = new MoveableTexture(3200);
    int oldScale;
    int newScale = -1;
    FilePos lastPos = null;
    boolean dragging = false;
    float scale = 0.2f;
    int globalRadius = 100;
    boolean globalSquare = true;
    boolean keepWorld = false;
    boolean pregenRuns = false;

    public GuiSeedPreview(GuiCreateWorld gui) {
        this.seed = new WorldSeed(gui);
        this.seed.removePreview(false);
        this.seed.createPaths();
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
        set.addAll(ConfigManager.getDimensions());
        if (!ConfigManager.orderOnly) {
            set.addAll(Arrays.asList(DimensionManager.getStaticDimensionIDs()));
        }
        this.allDimensions.addValues(new ArrayList(set));
        this.oldScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;
        this.onReopening();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void onReopening() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.displayTexture.createTextureIfMissing();
        this.displayTexture.centerTexture();
        if (this.newScale != -1) {
            Minecraft.func_71410_x().field_71474_y.field_74335_Z = this.newScale;
        }
    }

    @SubscribeEvent
    public void onChunkSaved(ChunkDataEvent.Save event) {
        Chunk chunk = event.getChunk();
        WorldInstance instance = this.dimensions.get(chunk.func_177412_p().field_73011_w.getDimension());
        if (instance == null) {
            return;
        }
        instance.addChunk(chunk);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.registerUnmovedButton(0, 30, 62, 45, 20, "Random");
        this.registerUnmovedButton(1, 80, 62, 40, 20, "Apply");
        this.registerUnmovedButton(2, 125, 62, 65, 20, "Apply Size");
        WorldInstance instance = this.getCurrentWorld();
        this.registerButton(new GuiSlider(3, 55, 95, 110, 20, "Radius: ", " Chunks", 1.0, 1000.0, instance != null ? (double)instance.getRadius() : (double)this.globalRadius, false, true, this).setScrollEffect(1.0));
        this.registerUnmovedButton(4, 30, 95, 20, 20, "<");
        this.registerUnmovedButton(5, 169, 95, 20, 20, ">");
        this.registerUnmovedButton(6, 30, 118, 80, 20, this.terrainOnly ? "Terrain" : "Terrain & Post");
        this.registerUnmovedButton(7, 115, 118, 75, 20, "Add Post");
        this.registerUnmovedButton(8, 30, 140, 160, 20, "Dim: " + this.allDimensions.getValue() + " (" + WorldSeed.getDimensionName(this.allDimensions.getValue()) + ")");
        this.registerUnmovedButton(20, 30, 162, 160, 20, "Generation Shape: Square");
        this.registerUnmovedButton(9, 30, 193, 80, 20, "Start Gen");
        this.registerUnmovedButton(10, 115, 193, 75, 20, "Stop Gen");
        this.registerButton(new GuiSlider(11, 55, 215, 110, 20, "Speed: ", " ms/t", 10.0, 1000.0, ChunkProcessor.INSTANCE.getMaxTime(), false, true, this).setScrollEffect(1.0));
        this.registerUnmovedButton(12, 30, 215, 20, 20, "<");
        this.registerUnmovedButton(13, 169, 215, 20, 20, ">");
        this.registerUnmovedButton(14, 30, 247, 160, 20, "Map View: " + this.mapViews.getValue());
        this.registerUnmovedButton(15, 30, 269, 75, 20, "Slime Chunks");
        this.registerUnmovedButton(16, 115, 269, 75, 20, "Structures");
        this.registerUnmovedButton(30, 25, this.field_146295_m - 50, 80, 20, "Back");
        this.registerUnmovedButton(31, 110, this.field_146295_m - 50, 80, 20, "Keep World");
        this.registerUnmovedButton(99, 0, 0, 70, 15, "Lower Scale");
        this.registerUnmovedButton(100, this.field_146294_l - 202, 20, 20, 15, "GC");
        this.seedName = new GuiTextField(32, this.field_146297_k.field_71466_p, 30, 40, 160, 20);
        this.seedName.func_146205_d(true);
        this.seedName.func_146180_a(this.seed.getTextSeed());
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void updateButtons() {
        WorldInstance instance;
        boolean isRunning = ChunkProcessor.INSTANCE.isRunning();
        if (isRunning) {
            this.seedName.func_146195_b(false);
        }
        this.getIDButton((int)0).field_146124_l = !isRunning;
        this.getIDButton((int)1).field_146124_l = !isRunning;
        this.getIDButton((int)2).field_146124_l = !isRunning;
        this.getIDButton((int)3).field_146124_l = !isRunning;
        this.getIDButton((int)4).field_146124_l = !isRunning;
        this.getIDButton((int)5).field_146124_l = !isRunning;
        this.getIDButton((int)6).field_146124_l = !isRunning;
        this.getIDButton((int)7).field_146124_l = !isRunning;
        this.getIDButton((int)8).field_146124_l = !isRunning;
        this.getIDButton((int)9).field_146124_l = !isRunning;
        this.getIDButton((int)10).field_146124_l = isRunning;
        this.getIDButton((int)20).field_146124_l = !isRunning;
        this.getIDButton((int)30).field_146124_l = !isRunning;
        this.getIDButton((int)31).field_146124_l = !isRunning;
        this.getIDButton((int)9).field_146125_m = this.field_146295_m >= 264;
        this.getIDButton((int)10).field_146125_m = this.field_146295_m >= 264;
        this.getIDButton((int)11).field_146125_m = this.field_146295_m >= 287;
        this.getIDButton((int)12).field_146125_m = this.field_146295_m >= 287;
        this.getIDButton((int)13).field_146125_m = this.field_146295_m >= 287;
        this.getIDButton((int)14).field_146125_m = this.field_146295_m >= 318;
        this.getIDButton((int)15).field_146125_m = this.field_146295_m >= 342;
        this.getIDButton((int)16).field_146125_m = this.field_146295_m >= 342;
        boolean bl = this.getIDButton((int)99).field_146125_m = this.field_146295_m < 342;
        if (ChunkProcessor.INSTANCE.isRunning()) {
            this.pregenRuns = true;
        } else if (this.pregenRuns) {
            this.stopTask();
        }
        if (this.fakeServer == null) {
            this.createServer();
        }
        boolean shape = (instance = this.getCurrentWorld()) == null ? this.globalSquare : instance.isSquare();
        this.getIDButton((int)20).field_146126_j = "Generation Shape: " + (shape ? "Square" : "Circle");
    }

    public void func_146281_b() {
        this.stopTask();
        if (Minecraft.func_71410_x().field_71474_y.field_74335_Z != this.oldScale) {
            Minecraft.func_71410_x().field_71474_y.field_74335_Z = this.oldScale;
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        if (!this.keepWorld) {
            this.removePreview(false);
        }
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    public boolean removePreview(boolean tempOnly) {
        this.mapData.shutdown();
        this.processor.terminate();
        return this.seed.forceRemovePreview(tempOnly);
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            this.seedName.func_146180_a(Long.toString(new Random().nextLong()));
        } else if (id == 1) {
            this.applyChanges();
        } else if (id == 2) {
            this.applyNewSize();
        } else if (id == 4 || id == 5) {
            GuiSlider slider = (GuiSlider)this.getIDButton(3);
            int value = id == 5 ? 1 : -1;
            slider.setValue(slider.getValueInt() + (value *= GuiScreen.func_146271_m() ? 10 : 1));
            slider.updateSlider();
        } else if (id == 6) {
            this.terrainOnly = !this.terrainOnly;
            button.field_146126_j = this.terrainOnly ? "Terrain" : "Terrain & Post";
        } else if (id == 7) {
            this.startTask(2);
        } else if (id == 8) {
            if (GuiScreen.func_146272_n()) {
                this.allDimensions.prev();
            } else {
                this.allDimensions.next();
            }
            button.field_146126_j = "Dim: " + this.allDimensions.getValue() + " (" + WorldSeed.getDimensionName(this.allDimensions.getValue()) + ")";
            this.toggleDimension();
        } else if (id == 9) {
            this.startTask(this.terrainOnly ? 0 : 1);
        } else if (id == 10) {
            this.stopTask();
        } else if (id == 12 || id == 13) {
            GuiSlider slider = (GuiSlider)this.getIDButton(11);
            int value = id == 13 ? 1 : -1;
            slider.setValue(slider.getValueInt() + (value *= GuiScreen.func_146271_m() ? 10 : 1));
            slider.updateSlider();
        } else if (id == 14) {
            if (GuiScreen.func_146272_n()) {
                this.mapViews.prev();
            } else {
                this.mapViews.next();
            }
            button.field_146126_j = "Map View: " + this.mapViews.getValue();
            this.updateTexture();
        } else if (id == 15) {
            this.slimeChunks = !this.slimeChunks;
        } else if (id == 16) {
            this.structures = !this.structures;
        } else if (id == 20) {
            WorldInstance instance = this.getCurrentWorld();
            if (instance != null) {
                instance.toggleShape();
            } else {
                this.globalSquare = !this.globalSquare;
            }
        } else if (id == 30) {
            this.field_146297_k.func_147108_a((GuiScreen)this.seed.getPrevGui());
        } else if (id == 31) {
            boolean save = true;
            for (WorldInstance instance : this.dimensions.values()) {
                if (instance.isSaveToUse()) continue;
                save = false;
            }
            this.keepWorld = true;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiKeepWorld(this, save));
            this.keepWorld = false;
        } else if (id == 99) {
            int oldScale = this.oldScale;
            Minecraft.func_71410_x().field_71474_y.field_74335_Z = new ScaledResolution(this.field_146297_k).func_78325_e() - 1;
            this.keepWorld = true;
            this.field_146297_k.func_147108_a((GuiScreen)this);
            this.keepWorld = false;
            this.oldScale = oldScale;
        } else if (id == 100) {
            System.gc();
        }
    }

    @Override
    public void onChangeSliderValue(GuiSlider slider) {
        if (slider.field_146127_k == 3) {
            this.globalRadius = slider.getValueInt();
        }
        if (slider.field_146127_k == 11) {
            ChunkProcessor.INSTANCE.setMaxTime(slider.getValueInt());
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.seedName.func_146206_l()) {
            this.seedName.func_146201_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.seedName.func_146192_a(mouseX, mouseY, mouseButton);
        if (this.seedName.func_146206_l()) {
            return;
        }
        if (this.isInFrame(mouseX, mouseY)) {
            this.dragging = true;
            this.lastPos = new FilePos(mouseX, mouseY);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.dragging = false;
    }

    public void applyChanges() {
        long newSeed = WorldSeed.makeSeed(this.seedName.func_146179_b());
        if (newSeed == this.seed.getSeed()) {
            return;
        }
        this.seed.setSeed(this.seedName.func_146179_b());
        if (this.fakeServer != null) {
            this.seed.destroyServer(this.fakeServer);
            this.fakeServer = null;
        }
        for (Integer value : this.dimensions.keySet()) {
            this.mapData.removeDimension(value);
        }
        this.dimensions.clear();
        this.seed.removePreview(false);
        this.displayTexture.centerTexture();
        this.displayTexture.clearTexture();
        this.updateTexture();
    }

    public void applyNewSize() {
        int radius = ((GuiSlider)this.getIDButton(3)).getValueInt();
        this.displayTexture.resizeTexture(radius * 32);
        this.displayTexture.centerTexture();
        this.updateTexture();
        WorldInstance current = this.getCurrentWorld();
        if (current != null) {
            current.setRadius(radius);
        }
    }

    public void toggleDimension() {
        for (WorldInstance instance : this.dimensions.values()) {
            instance.setFocus(this.allDimensions.getValue(), this.mapViews.getIndex());
        }
        WorldInstance instance = this.getCurrentWorld();
        if (instance != null) {
            GuiSlider slider = (GuiSlider)this.getIDButton(3);
            slider.setValue(instance.getRadius());
            slider.updateSlider();
        }
        this.displayTexture.resizeTexture(((GuiSlider)this.getIDButton(3)).getValueInt() * 32);
        this.displayTexture.centerTexture();
        this.displayTexture.clearTexture();
        this.updateTexture();
    }

    public void updateTexture() {
        WorldInstance instance = this.getCurrentWorld();
        if (instance != null) {
            instance.reload(this.mapViews.getIndex());
        }
    }

    public void createServer() {
        this.fakeServer = this.seed.createServer();
    }

    public void startServer() {
        if (this.fakeServer.func_71200_ad()) {
            return;
        }
        this.fakeServer.func_71256_s();
        while (!this.fakeServer.func_71200_ad()) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
    }

    public void startTask(int state) {
        if (ChunkProcessor.INSTANCE.isRunning()) {
            return;
        }
        this.startServer();
        TaskStorage.getStorage().clearAll();
        WorldInstance instance = this.getOrCreateWorld();
        ChunkProcessor.INSTANCE.startTask(instance.createTask(state));
    }

    public void stopTask() {
        this.pregenRuns = false;
        this.seed.destroyServer(this.fakeServer);
        this.fakeServer = null;
    }

    public WorldInstance getOrCreateWorld() {
        WorldInstance instance = this.dimensions.get(this.allDimensions.getValue());
        if (instance == null) {
            instance = new WorldInstance(this.allDimensions.getValue(), this.globalSquare, this.mapData.createDimension(this.allDimensions.getValue()));
            this.dimensions.put(this.allDimensions.getValue(), instance);
            int radius = ((GuiSlider)this.getIDButton(3)).getValueInt();
            instance.setRadius(radius);
            this.displayTexture.resizeTexture(radius * 32);
            this.displayTexture.centerTexture();
        }
        return instance;
    }

    public WorldInstance getCurrentWorld() {
        return this.dimensions.get(this.allDimensions.getValue());
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int posZ;
        int effect;
        this.updateButtons();
        this.process();
        this.func_146276_q_();
        this.drawFrame();
        if (this.seedName != null) {
            this.seedName.func_146194_f();
        }
        if (this.isInFrame(mouseX, mouseY) && (effect = Mouse.getDWheel() / 120) != 0) {
            float data = 1.0f + (GuiSeedPreview.func_146272_n() ? 2.0f : 0.1f) * (float)effect;
            this.scale *= data;
            if (this.scale < 0.01f) {
                this.scale = 0.01f;
            } else if (this.scale > 60.0f) {
                this.scale = 60.0f;
            }
        }
        if (this.dragging) {
            this.displayTexture.moveTexture(-((float)(this.lastPos.x - mouseX) / this.scale), -((float)(this.lastPos.z - mouseY) / this.scale));
            this.lastPos = new FilePos(mouseX, mouseY);
        }
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        double scaleW = (double)this.field_146297_k.field_71443_c / res.func_78327_c();
        double scaleH = (double)this.field_146297_k.field_71440_d / res.func_78324_d();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)(200.0 * scaleW)), (int)((int)(40.0 * scaleH)), (int)((int)((double)this.field_146297_k.field_71443_c - 240.0 * scaleW)), (int)((int)((double)this.field_146297_k.field_71440_d - 80.0 * scaleH)));
        GlStateManager.func_179094_E();
        this.displayTexture.translate((this.field_146294_l + 140) / 2, this.field_146295_m / 2, this.scale);
        this.displayTexture.render(this.slimeChunks, new MoveableTexture.IRenderFunction(){

            @Override
            public void render(float x, float y, int width, int height) {
                GuiSeedPreview.this.renderTexture(x, y, width, height, GuiSeedPreview.this.field_73735_i);
            }
        });
        WorldInstance instance = this.getCurrentWorld();
        if (instance == null) {
            GlStateManager.func_179121_F();
            GL11.glDisable((int)3089);
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.drawPostFrame();
            this.handleButtonToolTips(mouseX, mouseY);
            return;
        }
        GlStateManager.func_179109_b((float)(this.displayTexture.getWidth() / 2), (float)(this.displayTexture.getHeight() / 2), (float)0.0f);
        float offsetX = this.displayTexture.getX();
        float offsetY = this.displayTexture.getY();
        if (this.slimeChunks) {
            for (FilePos pos : instance.getSlimeChunks()) {
                float minX = pos.x * 16;
                float minY = pos.z * 16;
                float maxX = pos.x * 16 + 16;
                float maxY = pos.z * 16 + 16;
                this.drawArea(minX += offsetX, minY += offsetY, maxX += offsetX, maxY += offsetY, SLIME_COLOR.getRGB());
            }
        }
        Map<String, Set<StructureStart>> types = instance.getStructures();
        if (this.structures) {
            int range = instance.getRadius() * 16;
            for (Map.Entry<String, Set<StructureStart>> starts : types.entrySet()) {
                StructureBoundingBox box;
                String name = starts.getKey();
                Color pre = new Color((name.hashCode() & 0xAAAAAA) + 0x444444, false);
                int color = new Color(pre.getRed(), pre.getGreen(), pre.getBlue(), 128).getRGB();
                if (name.equalsIgnoreCase("mineshaft")) continue;
                if (name.equalsIgnoreCase("temple")) {
                    for (StructureStart start : starts.getValue()) {
                        if (!start.func_75069_d()) continue;
                        box = start.func_75071_a();
                        if (box.field_78893_d + 20 <= -range || box.field_78897_a - 20 >= range || box.field_78892_f + 20 <= -range || box.field_78896_c - 20 >= range) continue;
                        this.drawArea((float)box.field_78897_a + offsetX - 20.0f, (float)box.field_78896_c + offsetY - 20.0f, (float)box.field_78893_d + offsetX + 20.0f, (float)box.field_78892_f + offsetY + 20.0f, color);
                    }
                    continue;
                }
                for (StructureStart start : starts.getValue()) {
                    if (!start.func_75069_d()) continue;
                    box = start.func_75071_a();
                    if (box.field_78893_d <= -range || box.field_78897_a >= range || box.field_78892_f <= -range || box.field_78896_c >= range) continue;
                    this.drawArea((float)box.field_78897_a + offsetX, (float)box.field_78896_c + offsetY, (float)box.field_78893_d + offsetX, (float)box.field_78892_f + offsetY, color);
                }
            }
        }
        GlStateManager.func_179121_F();
        GL11.glDisable((int)3089);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawPostFrame();
        this.handleButtonToolTips(mouseX, mouseY);
        if (!this.isInFrame(mouseX, mouseY)) {
            return;
        }
        offsetX = this.displayTexture.getX();
        offsetY = this.displayTexture.getY();
        float xMouse = mouseX;
        float yMouse = mouseY;
        xMouse -= (float)((this.field_146294_l + 140) / 2);
        xMouse /= this.scale;
        yMouse -= (float)(this.field_146295_m / 2);
        yMouse /= this.scale;
        offsetY -= (yMouse -= 0.5f);
        int radius = instance.getRadius();
        int blockRadius = radius * 16;
        if ((offsetX -= (xMouse -= 0.5f)) > 0.0f || offsetY > 0.0f) {
            return;
        }
        int posX = (int)Math.abs(offsetX);
        IChunkData data = instance.getChunk((posX >> 4) - radius, ((posZ = (int)Math.abs(offsetY)) >> 4) - radius);
        if (data == null) {
            return;
        }
        int x = posX % 16;
        int z = posZ % 16;
        int y = data.getHeight(x, z);
        int blockX = posX - blockRadius;
        int blockZ = posZ - blockRadius;
        ArrayList<String> toDraw = new ArrayList<String>();
        toDraw.add("Position: X: " + blockX + (y < 0 ? "" : ", Y: " + y) + ", Z: " + blockZ);
        toDraw.add("Chunk: X: " + ((posX >> 4) - radius) + ", Z: " + ((posZ >> 4) - radius));
        toDraw.add("Biome: " + Biome.func_180276_a((int)data.getBiome(x, z), (Biome)Biomes.field_76772_c).func_185359_l());
        if (data.isSlimeChunk()) {
            toDraw.add("Slime Chunk");
        }
        block4: for (Map.Entry<String, Set<StructureStart>> entry : types.entrySet()) {
            StructureBoundingBox box;
            String name = entry.getKey();
            if (name.equalsIgnoreCase("mineshaft")) continue;
            if (name.equalsIgnoreCase("temple")) {
                for (StructureStart start : entry.getValue()) {
                    if (!start.func_75069_d()) continue;
                    box = start.func_75071_a();
                    if (blockX < box.field_78897_a - 20 || blockX > box.field_78893_d + 20 || blockZ < box.field_78896_c - 20 || blockZ > box.field_78892_f + 20) continue;
                    toDraw.add(name);
                    continue block4;
                }
                continue;
            }
            for (StructureStart start : entry.getValue()) {
                if (!start.func_75069_d()) continue;
                box = start.func_75071_a();
                if (blockX < box.field_78897_a || blockX > box.field_78893_d || blockZ < box.field_78896_c || blockZ > box.field_78892_f) continue;
                toDraw.add(name);
                continue block4;
            }
        }
        this.drawListText(toDraw, mouseX, mouseY);
    }

    public void process() {
        for (WorldInstance instance : this.dimensions.values()) {
            instance.update(this.mapViews.getIndex(), this.processor);
            if (!instance.isFocus()) continue;
            instance.render(this.displayTexture);
        }
    }

    public void drawPostFrame() {
        this.drawSimpleText("Seed: ", 30, 30, 0x404040);
        this.drawSimpleText("Generation Options: ", 30, 85, 0x404040);
        if (this.field_146295_m >= 243) {
            this.drawSimpleText("Generation Control", 30, 184, 0x404040);
        }
        if (this.field_146295_m >= 297) {
            this.drawSimpleText("Toggle Overlays", 30, 237, 0x404040);
        }
        if (this.field_146295_m < 342) {
            this.drawSimpleText("Window height is to small", 30, 21, Color.RED.getRGB());
        }
        long[] data = WorldSeed.getData();
        this.drawSimpleText("Ram: " + WorldSeed.value(data[0]) + " MB / " + WorldSeed.value(data[2]) + " MB", this.field_146294_l - 178, 24, 0x404040);
        ChunkProcessor instance = ChunkProcessor.INSTANCE;
        this.drawSimpleText(instance.getCurrentProcessed() + " / " + instance.getMaxProcess() + " Chunks", 201, this.field_146295_m - 31, 0x404040);
    }

    public void drawFrame() {
        this.drawSimpleRect(20, 20, this.field_146294_l - 20, this.field_146295_m - 20, -3750202, false);
        this.drawSimpleRect(200, 40, this.field_146294_l - 40, this.field_146295_m - 40, -7631989, true);
        long[] data = WorldSeed.getData();
        this.drawSimpleRect(this.field_146294_l - 180, 22, this.field_146294_l - 40, 33, -7631989, true);
        this.drawSimpleRect(200, this.field_146295_m - 35, this.field_146294_l - 40, this.field_146295_m - 22, -7631989, true);
        double value = (double)data[0] / (double)data[2];
        GuiSeedPreview.func_73734_a((int)(this.field_146294_l - 180), (int)22, (int)(this.field_146294_l - 40 - (int)(140.0 - 140.0 * value)), (int)33, (int)Color.GREEN.getRGB());
        ChunkProcessor instance = ChunkProcessor.INSTANCE;
        value = instance.getTask() != null ? (double)instance.getCurrentProcessed() / (double)instance.getMaxProcess() : 0.0;
        int toRender = this.field_146294_l - 200 - 40;
        GuiSeedPreview.func_73734_a((int)200, (int)(this.field_146295_m - 35), (int)(this.field_146294_l - 40 - (int)((double)toRender - (double)toRender * value)), (int)(this.field_146295_m - 22), (int)Color.GREEN.getRGB());
    }

    public void handleButtonToolTips(int mouseX, int mouseY) {
        ArrayList<String> list;
        GuiButton button = this.getIDButton(3);
        if (button.func_146115_a()) {
            list = new ArrayList<String>();
            int radius = ((GuiSlider)button).getValueInt();
            int worldSize = radius * 32;
            int value = radius * 2;
            value *= value;
            list.add("WorldSize: " + worldSize + "x" + worldSize + " Blocks");
            list.add("");
            list.add("Expected Memory Usage");
            list.add("Ram Usage: ");
            list.add("PregenTask: +" + BIG_FORMAT.format(WorldSeed.value((long)value * 320L)) + " MB");
            list.add("");
            list.add("GPU Ram Usage: " + BIG_FORMAT.format(WorldSeed.value((long)value * 1024L)) + " MB");
            list.add("");
            list.add("Hard Drive Usage: (Accumulate Per Generated Dimension)");
            list.add("World Usage: +" + BIG_FORMAT.format(WorldSeed.value((long)value * 8192L)) + " MB");
            list.add("Preview Texture: +" + BIG_FORMAT.format(WorldSeed.value((long)value * IFileProvider.FileType.Chunk_Data.getOffset())) + " MB (Temporary)");
            list.add("HeightMap: +" + BIG_FORMAT.format(WorldSeed.value((long)value * IFileProvider.FileType.HeightData.getOffset())) + " MB (Temporary)");
            this.drawListText(list, mouseX, mouseY + 30);
        }
        if ((button = this.getIDButton(11)).func_146115_a() && ((GuiSlider)button).getValueInt() > 250) {
            list = new ArrayList();
            list.add("Anything above makes 250ms/t makes no sense and actually slows down the speed");
            this.drawListText(list, mouseX, mouseY - 15);
        }
        if (this.getIDButton(15).func_146115_a()) {
            this.drawListText(Arrays.asList("Press To Toggle the Slime Chunk Rendering on Map"), mouseX, mouseY - 15);
        }
        if (this.getIDButton(16).func_146115_a()) {
            this.drawListText(Arrays.asList("Press To Toggle the Structure Rendering on Map"), mouseX, mouseY - 15);
        }
        if (this.getIDButton(100).func_146115_a()) {
            this.drawListText(Arrays.asList("Java Memory Cleanup (also known as Garbage Collection)", "Will Freeze the Game for a couple seconds!"), mouseX, mouseY + 30);
        }
    }

    public boolean isInFrame(int mouseX, int mouseY) {
        return mouseX >= 200 && mouseX <= this.field_146294_l - 40 && mouseY >= 40 && mouseY <= this.field_146295_m - 40;
    }
}

