/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.module;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.reference.IReference;
import org.squiddev.plethora.api.reference.Reference;

public class BasicModuleContainer
implements IModuleContainer {
    public static final IModuleContainer EMPTY = new BasicModuleContainer(Collections.emptySet());
    public static final IReference<IModuleContainer> EMPTY_REF = Reference.id(EMPTY);
    private final Set<ResourceLocation> modules;

    public BasicModuleContainer(@Nonnull Set<ResourceLocation> modules) {
        Objects.requireNonNull(modules, "modules cannot be null");
        this.modules = Collections.unmodifiableSet(modules);
    }

    @Override
    public boolean hasModule(@Nonnull ResourceLocation module) {
        return this.modules.contains(module);
    }

    @Override
    @Nonnull
    public Set<ResourceLocation> getModules() {
        return this.modules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicModuleContainer that = (BasicModuleContainer)o;
        return this.modules.equals(that.modules);
    }

    public int hashCode() {
        return this.modules.hashCode();
    }
}

