/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object3d;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ColourableObject;
import org.squiddev.plethora.gameplay.modules.glasses.objects.Scalable;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.DepthTestable;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.MultiPoint3D;
import org.squiddev.plethora.utils.ByteBufUtils;

public class Line3D
extends ColourableObject
implements MultiPoint3D,
DepthTestable,
Scalable {
    private Vec3d start;
    private Vec3d end;
    private float thickness = 1.0f;
    private boolean depthTest = true;

    public Line3D(int id, int parent) {
        super(id, parent, (byte)13);
    }

    @Override
    @Nonnull
    public Vec3d getPoint(int idx) {
        switch (idx) {
            case 0: {
                return this.start;
            }
            case 1: {
                return this.end;
            }
        }
        throw new IndexOutOfBoundsException("No vertex #" + idx);
    }

    @Override
    public void setVertex(int idx, @Nonnull Vec3d point) {
        switch (idx) {
            case 0: {
                if (Objects.equal((Object)this.start, (Object)point)) break;
                this.start = point;
                this.setDirty();
                break;
            }
            case 1: {
                if (Objects.equal((Object)this.end, (Object)point)) break;
                this.end = point;
                this.setDirty();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("No vertex #" + idx);
            }
        }
    }

    @Override
    public int getVertices() {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        Line3D.setupFlat();
        if (this.start != null && this.end != null) {
            if (this.depthTest) {
                GlStateManager.func_179126_j();
            } else {
                GlStateManager.func_179097_i();
            }
            GlStateManager.func_187441_d((float)this.thickness);
            GL11.glEnable((int)2848);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(this.start.field_72450_a, this.start.field_72448_b, this.start.field_72449_c).func_181669_b(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha()).func_181675_d();
            buffer.func_181662_b(this.end.field_72450_a, this.end.field_72448_b, this.end.field_72449_c).func_181669_b(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha()).func_181675_d();
            tessellator.func_78381_a();
            GL11.glDisable((int)2848);
            GlStateManager.func_187441_d((float)1.0f);
        }
    }

    @Override
    public boolean hasDepthTest() {
        return this.depthTest;
    }

    @Override
    public void setDepthTest(boolean depthTest) {
        if (this.depthTest != depthTest) {
            this.depthTest = depthTest;
            this.setDirty();
        }
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        super.writeInitial(buf);
        ByteBufUtils.writeVec3d(buf, this.start);
        ByteBufUtils.writeVec3d(buf, this.end);
        buf.writeFloat(this.thickness);
        buf.writeBoolean(this.depthTest);
    }

    @Override
    public void readInitial(ByteBuf buf) {
        super.readInitial(buf);
        this.start = ByteBufUtils.readVec3d(buf);
        this.end = ByteBufUtils.readVec3d(buf);
        this.thickness = buf.readFloat();
        this.depthTest = buf.readBoolean();
    }

    @Override
    public float getScale() {
        return this.thickness;
    }

    @Override
    public void setScale(float scale) {
        if (this.thickness != scale) {
            this.thickness = MathHelper.func_76131_a((float)scale, (float)1.0f, (float)5.0f);
            this.setDirty();
        }
    }
}

