/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.chickens;

import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.module.IModuleContainer;

public final class MethodsAnalyzer {
    private MethodsAnalyzer() {
    }

    @PlethoraMethod(module={"chickens:analyzer"}, modId="chickens", doc="-- Get a list of all chicken species, with the species name as the index")
    public static Map<String, TypedMeta<ChickensRegistryItem, ?>> getSpeciesList(@Nonnull IContext<IModuleContainer> context) {
        return ChickensRegistry.getItems().stream().collect(Collectors.toMap(item -> item.getRegistryName().toString(), item -> context.makePartialChild(item).getMeta(), (a, b) -> b));
    }

    @Optional
    @PlethoraMethod(module={"chickens:analyzer"}, modId="chickens", doc="-- Get a single chicken species")
    public static TypedMeta<ChickensRegistryItem, ?> getSpecies(@Nonnull IContext<IModuleContainer> context, String name) {
        ChickensRegistryItem species = ChickensRegistry.getByRegistryName((String)name);
        return species != null ? context.makePartialChild(species).getMeta() : null;
    }
}

