/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.meta;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.output.NullOutputStream;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BasicMetaProvider;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.integration.PlethoraIntegration;

@Injects
public final class MetaItemBasic
extends BasicMetaProvider<ItemStack> {
    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull ItemStack stack) {
        NBTTagCompound displayTag;
        NBTTagCompound tag;
        if (stack.func_190926_b()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        MetaItemBasic.fillBasicMeta(data, stack);
        String display = stack.func_82833_r();
        data.put("displayName", display == null || display.isEmpty() ? stack.func_77977_a() : display);
        data.put("rawName", stack.func_77977_a());
        data.put("maxCount", stack.func_77976_d());
        data.put("maxDamage", stack.func_77958_k());
        if (stack.func_77973_b().showDurabilityBar(stack)) {
            data.put("durability", stack.func_77973_b().getDurabilityForDisplay(stack));
        }
        if ((tag = stack.func_77978_p()) != null && tag.func_150297_b("display", 10) && (displayTag = tag.func_74775_l("display")).func_150297_b("Lore", 9)) {
            NBTTagList loreTag = displayTag.func_150295_c("Lore", 8);
            LuaList<String> loreText = new LuaList<String>(loreTag.func_74745_c());
            for (NBTBase child : loreTag) {
                loreText.add(((NBTTagString)child).func_150285_a_());
            }
            data.put("lore", loreText.asMap());
        }
        return data;
    }

    @Nonnull
    public static HashMap<String, Object> getBasicMeta(@Nonnull ItemStack stack) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        MetaItemBasic.fillBasicMeta(data, stack);
        return data;
    }

    private static void fillBasicMeta(@Nonnull Map<? super String, Object> data, @Nonnull ItemStack stack) {
        data.put("name", stack.func_77973_b().getRegistryName().toString());
        data.put("damage", stack.func_77952_i());
        data.put("count", stack.func_190916_E());
        data.put("nbtHash", MetaItemBasic.getNBTHash(stack));
    }

    @Override
    @Nonnull
    public ItemStack getExample() {
        return new ItemStack(Items.field_151055_y, 5);
    }

    @Nullable
    public static String getNBTHash(@Nonnull ItemStack stack) {
        return stack.func_77942_o() ? MetaItemBasic.getNBTHash(stack.func_77978_p()) : null;
    }

    @Nullable
    public static String getNBTHash(@Nullable NBTTagCompound tag) {
        if (tag == null || tag.func_82582_d()) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            NullOutputStream dump = new NullOutputStream();
            DigestOutputStream hasher = new DigestOutputStream((OutputStream)dump, digest);
            DataOutputStream output = new DataOutputStream(hasher);
            CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)output);
            byte[] hash = digest.digest();
            return new String(Hex.encodeHex((byte[])hash));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            PlethoraIntegration.LOG.error("Cannot hash NBT", (Throwable)e);
            return null;
        }
    }
}

