/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.meta;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.meta.BasicMetaProvider;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.integration.ItemEntityStorageMetaProvider;
import org.squiddev.plethora.utils.TypedField;
import org.squiddev.plethora.utils.WorldDummy;

@Injects
public final class VanillaMeta {
    public static final IMetaProvider<TileEntitySign> TILE_SIGN = new BasicMetaProvider<TileEntitySign>("Provides the text upon the sign."){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull TileEntitySign target) {
            return Collections.singletonMap("lines", VanillaMeta.getSignLines(target));
        }

        @Override
        @Nonnull
        public TileEntitySign getExample() {
            TileEntitySign sign = new TileEntitySign();
            sign.field_145915_a[0] = new TextComponentString("This is");
            sign.field_145915_a[1] = new TextComponentString("my rather fancy");
            sign.field_145915_a[2] = new TextComponentString("sign.");
            return sign;
        }
    };
    public static final IMetaProvider<MobSpawnerBaseLogic> SPAWNER_LOGIC = new BaseMetaProvider<MobSpawnerBaseLogic>("Provides the entities that this spawner will spawn."){
        private final TypedField<MobSpawnerBaseLogic, List<WeightedSpawnerEntity>> FIELD_POTENTIAL = TypedField.of(MobSpawnerBaseLogic.class, "potentialSpawns", "field_98285_e");
        private final TypedField<MobSpawnerBaseLogic, WeightedSpawnerEntity> FIELD_DATA = TypedField.of(MobSpawnerBaseLogic.class, "spawnData", "field_98282_f");

        @Override
        @Nonnull
        public Map<String, Map<Integer, Map<String, ?>>> getMeta(@Nonnull IPartialContext<MobSpawnerBaseLogic> context) {
            List<WeightedSpawnerEntity> potentialSpawns = this.FIELD_POTENTIAL.get(context.getTarget());
            WeightedSpawnerEntity spawnData = this.FIELD_DATA.get(context.getTarget());
            if (potentialSpawns == null && spawnData == null) {
                return Collections.emptyMap();
            }
            if (potentialSpawns == null || potentialSpawns.isEmpty()) {
                potentialSpawns = Collections.singletonList(spawnData);
            }
            IWorldLocation location = context.getContext("origin", IWorldLocation.class);
            LuaList spawns = new LuaList(potentialSpawns.size());
            for (WeightedSpawnerEntity entry : potentialSpawns) {
                if (location != null) {
                    Vec3d pos = location.getLoc();
                    Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)entry.func_185277_b(), (World)location.getWorld(), (double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c, (boolean)false);
                    if (entity != null) {
                        spawns.add(context.makePartialChild(entity).getMeta());
                        continue;
                    }
                }
                spawns.add(ItemEntityStorageMetaProvider.getBasicDetails(entry.func_185277_b()));
            }
            return Collections.singletonMap("spawnedEntities", spawns.asMap());
        }

        @Override
        @Nonnull
        public MobSpawnerBaseLogic getExample() {
            MobSpawnerBaseLogic logic = new MobSpawnerBaseLogic(){

                public void func_98267_a(int id) {
                }

                @Nonnull
                public World func_98271_a() {
                    return WorldDummy.INSTANCE;
                }

                @Nonnull
                public BlockPos func_177221_b() {
                    return BlockPos.field_177992_a;
                }
            };
            logic.func_190894_a(new ResourceLocation("minecraft", "squid"));
            return logic;
        }
    };
    public static final IMetaProvider<ItemStack> ENCHANTED_ITEM = new BasicMetaProvider<ItemStack>("Provides the enchantments on an item"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull ItemStack target) {
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)target);
            if (enchants.isEmpty()) {
                return Collections.emptyMap();
            }
            LuaList out = new LuaList(enchants.size());
            for (Map.Entry entry : enchants.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                HashMap<String, Object> enchant = new HashMap<String, Object>(3);
                enchant.put("name", enchantment.func_77320_a());
                enchant.put("level", level);
                enchant.put("fullName", enchantment.func_77316_c(level));
                out.add(enchant);
            }
            return Collections.singletonMap("enchantments", out.asMap());
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            ItemStack stack = new ItemStack(Items.field_151012_L);
            EnchantmentHelper.func_82782_a(Collections.singletonMap(Enchantments.field_185307_s, 5), (ItemStack)stack);
            return stack;
        }
    };
    public static final IMetaProvider<IEnergyStorage> ENERGY = new BasicMetaProvider<IEnergyStorage>("Provides the currently stored energy and capacity of a Forge Energy cell"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IEnergyStorage handler) {
            HashMap<String, Integer> out = new HashMap<String, Integer>(2);
            out.put("stored", handler.getEnergyStored());
            out.put("capacity", handler.getMaxEnergyStored());
            return Collections.singletonMap("energy", out);
        }

        @Override
        @Nonnull
        public IEnergyStorage getExample() {
            return new EnergyStorage(50000, 100, 100, 1000);
        }
    };

    private VanillaMeta() {
    }

    public static Map<Integer, String> getSignLines(TileEntitySign sign) {
        ITextComponent[] lines = sign.field_145915_a;
        HashMap<Integer, String> text = new HashMap<Integer, String>(lines.length);
        for (int i = 0; i < lines.length; ++i) {
            text.put(i + 1, lines[i].func_150260_c());
        }
        return text;
    }
}

