/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityGeneratorBase;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.platform.registry.Ic2States;
import ic2.core.util.helpers.AabbUtil;
import ic2.core.util.math.Box2D;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityOceanGenerator
extends TileEntityGeneratorBase {
    Checker check = new Checker(this);
    int ticker = 0;
    double modifier;

    public TileEntityOceanGenerator() {
        super(0);
        this.maxStorage = 8000;
        this.modifier = (double)IC2.config.getInt("energyGeneratorOcean") / 100.0;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return null;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return false;
    }

    @Override
    public ResourceLocation getTexture() {
        return null;
    }

    @Override
    public Box2D getEnergyBox() {
        return null;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.check.prepairChecking();
        }
    }

    @Override
    public boolean gainEnergy() {
        if (this.storage >= this.maxStorage) {
            return false;
        }
        if (this.production > 0) {
            this.storage += this.production;
        }
        return this.production > 0;
    }

    @Override
    public boolean needsFuel() {
        if (this.check.hasWork() || this.check.isFinished()) {
            return true;
        }
        if (++this.ticker % 6000 == 0) {
            this.check.prepairChecking();
        }
        return false;
    }

    @Override
    public boolean gainFuel() {
        if (this.check.isFinished()) {
            this.check.finishCalculation();
            this.check.cleanUp();
        }
        if (this.check.hasWork()) {
            this.check.processList();
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.production = nbt.func_74762_e("Production");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Production", this.production);
        return nbt;
    }

    public static class ObsticalEntry {
        Map<BlockPos, IBlockState> blocks = new LinkedHashMap<BlockPos, IBlockState>();
        List<BlockPos> generators = new ArrayList<BlockPos>();

        public void addEntry(BlockPos pos, IBlockState state) {
            this.blocks.put(pos, state);
            if (state.func_177230_c() == Ic2States.generator.func_177230_c()) {
                this.generators.add(pos);
            }
        }

        public void putAll(Map<BlockPos, IBlockState> entry) {
            this.blocks.putAll(entry);
            for (Map.Entry<BlockPos, IBlockState> key : entry.entrySet()) {
                if (key.getValue().func_177230_c() != Ic2States.generator.func_177230_c()) continue;
                this.generators.add(key.getKey());
            }
        }

        public boolean contains(List<BlockPos> list) {
            for (BlockPos other : list) {
                if (!this.blocks.containsKey(other)) continue;
                return true;
            }
            return false;
        }

        public float getWeight(World world) {
            float weight = 0.0f;
            AabbUtil.BoundingBox box = AabbUtil.BoundingBox.buildOutOfList(this.blocks.keySet());
            int counter = 0;
            for (BlockPos entry : box.getHollowIterator()) {
                IBlockState state = this.blocks.get(entry);
                if (state == null) continue;
                float hardness = 0.0f;
                try {
                    state.func_185887_b(world, entry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                weight = hardness < 0.0f ? (weight += 1.0f) : (state.func_177230_c().isAir(state, (IBlockAccess)world, entry) ? (weight += 5.0f) : (weight += hardness));
                ++counter;
            }
            if (counter > 1) {
                weight /= (float)counter;
                weight *= 2.0f;
            }
            if (this.generators.size() > 0) {
                for (BlockPos pos : this.generators) {
                    TileEntity tile = world.func_175625_s(pos);
                    if (!(tile instanceof TileEntityOceanGenerator)) continue;
                    weight += 25.0f;
                }
            }
            return weight;
        }
    }

    public static class Checker {
        final TileEntityOceanGenerator tile;
        Set<ObsticalEntry> obsticals = new ObjectLinkedOpenHashSet();
        AabbUtil.BoundingBox area;
        LongSet alreadyVisited = new LongOpenHashSet();
        LongSet onVisiting = new LongOpenHashSet();
        PriorityQueue<BlockPos> todoList = new ObjectArrayFIFOQueue();
        int waterBlocks = 0;
        boolean finished = false;

        public Checker(TileEntityOceanGenerator ocean) {
            this.tile = ocean;
        }

        public boolean hasWork() {
            return this.todoList.size() > 0;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void prepairChecking() {
            if (this.todoList.size() > 0 || this.finished) {
                return;
            }
            BlockPos start = this.tile.func_174877_v().func_177984_a();
            this.area = new AabbUtil.BoundingBox(start.func_177982_a(-7, 0, -7), start.func_177982_a(7, 15, 7));
            this.todoList.enqueue((Object)start);
            this.onVisiting.add(start.func_177986_g());
        }

        public void finishCalculation() {
            float efficiency = (float)this.waterBlocks / (float)(this.area.getBlocksInArea() / 2);
            float totalBlockage = 0.0f;
            for (ObsticalEntry entry : this.obsticals) {
                totalBlockage += entry.getWeight(this.tile.field_145850_b);
            }
            float result = 50.0f * efficiency;
            if ((result -= totalBlockage) < 0.0f) {
                result = 0.0f;
            }
            result = (float)((double)result * this.tile.modifier);
            this.tile.production = (int)result;
            this.tile.getNetwork().updateTileGuiField(this.tile, "production");
        }

        public void cleanUp() {
            this.obsticals.clear();
            this.alreadyVisited.clear();
            this.onVisiting.clear();
            this.todoList.clear();
            this.waterBlocks = 0;
            this.finished = false;
        }

        public void processList() {
            int ticker = 0;
            while (this.todoList.size() > 0 && ticker < 10) {
                ObsticalEntry newOne;
                EnumFacing facing2;
                BlockPos current = (BlockPos)this.todoList.dequeue();
                if (this.alreadyVisited.contains(current.func_177986_g())) continue;
                this.alreadyVisited.add(current.func_177986_g());
                if (!this.area.intersectsWith(current) || !this.tile.field_145850_b.func_175667_e(current)) continue;
                ++ticker;
                IBlockState state = this.tile.field_145850_b.func_180495_p(current);
                Material mat = state.func_185904_a();
                if (mat == Material.field_151586_h) {
                    ++this.waterBlocks;
                    for (EnumFacing facing2 : RotationList.ALL) {
                        this.todoList.enqueue((Object)current.func_177972_a(facing2));
                    }
                    continue;
                }
                if (mat.func_76224_d()) {
                    for (EnumFacing facing2 : RotationList.ALL) {
                        this.todoList.enqueue((Object)current.func_177972_a(facing2));
                    }
                    continue;
                }
                ArrayList<BlockPos> list = new ArrayList<BlockPos>();
                facing2 = RotationList.ALL.iterator();
                while (facing2.hasNext()) {
                    EnumFacing facing3 = (EnumFacing)facing2.next();
                    BlockPos newPos = current.func_177972_a(facing3);
                    if (this.alreadyVisited.contains(newPos.func_177986_g()) || this.onVisiting.contains(newPos.func_177986_g()) || !this.area.intersectsWith(newPos) || !this.tile.field_145850_b.func_175667_e(newPos)) continue;
                    list.add(newPos);
                    this.onVisiting.add(newPos.func_177986_g());
                }
                ArrayList<ObsticalEntry> fusion = new ArrayList<ObsticalEntry>();
                for (ObsticalEntry entry : this.obsticals) {
                    if (!entry.contains(list)) continue;
                    fusion.add(entry);
                }
                if (fusion.size() == 0) {
                    newOne = new ObsticalEntry();
                    newOne.addEntry(current, state);
                    this.obsticals.add(newOne);
                    continue;
                }
                if (fusion.size() == 1) {
                    ((ObsticalEntry)fusion.get(0)).addEntry(current, state);
                    continue;
                }
                newOne = new ObsticalEntry();
                for (ObsticalEntry entry : fusion) {
                    newOne.putAll(entry.blocks);
                }
                this.obsticals.removeAll(fusion);
                this.obsticals.add(newOne);
            }
            if (this.todoList.size() > 0) {
                return;
            }
            this.finished = true;
        }
    }
}

