/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.itemblacklist;

import net.doubledoordev.itemblacklist.client.ClientEventHandlers;
import net.doubledoordev.itemblacklist.data.GlobalBanList;
import net.doubledoordev.itemblacklist.util.CommandBlockItem;
import net.doubledoordev.itemblacklist.util.CommandUnpack;
import net.doubledoordev.itemblacklist.util.ItemBlacklisted;
import net.doubledoordev.itemblacklist.util.ServerEventHandlers;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="itemblacklist", dependencies="required:forge@[14.23.5.2779,);before:*", useMetadata=false, guiFactory="net.doubledoordev.itemblacklist.client.ModConfigGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class ItemBlacklist {
    @SidedProxy(clientSide="net.doubledoordev.itemblacklist.client.Proxy", serverSide="net.doubledoordev.itemblacklist.ItemBlacklist")
    public static ItemBlacklist proxy;
    @Mod.Instance
    public static ItemBlacklist instance;
    public static String message;
    public static boolean log;
    public boolean containerban;
    private boolean unpack4all;
    private Configuration configuration;
    private Logger logger;
    private boolean pastStart;

    public static Configuration getConfig() {
        return ItemBlacklist.instance.configuration;
    }

    public static Logger getLogger() {
        return ItemBlacklist.instance.logger;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        if (event.getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)ClientEventHandlers.I);
        }
        this.configuration = new Configuration(event.getSuggestedConfigurationFile());
        this.updateConfig();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide().isClient()) {
            ClientEventHandlers.init();
        }
    }

    private void updateConfig() {
        message = this.configuration.getString("message", "general", "Now is not the time to use that. ~Prof. Oak", "The message you get when using an item that is banned.");
        log = this.configuration.getBoolean("log", "general", false, "Log every instance of any banned item used. (SPAM WARNING!)");
        this.unpack4all = this.configuration.getBoolean("unpack4all", "general", true, "Let everyone unpack items by using the 'unpack' command. So items can be used in crafting.");
        this.containerban = this.configuration.getBoolean("containerban", "general", false, "Got a really stubborn item to ban? Enable this! Items will be banned whenever an inventory closes.");
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
        if (this.pastStart) {
            CommandHandler ch = (CommandHandler)FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
            if (this.unpack4all) {
                ch.func_71560_a((ICommand)CommandUnpack.I);
            } else {
                ch.func_71555_a().remove(CommandUnpack.I.func_71517_b());
                for (String s : CommandUnpack.I.func_71514_a()) {
                    ch.func_71555_a().remove(s);
                }
            }
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)CommandBlockItem.I);
        if (this.unpack4all) {
            event.registerServerCommand((ICommand)CommandUnpack.I);
        }
        GlobalBanList.init(event.getServer());
        MinecraftForge.EVENT_BUS.register((Object)ServerEventHandlers.I);
        this.pastStart = true;
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        MinecraftForge.EVENT_BUS.unregister((Object)ServerEventHandlers.I);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("itemblacklist")) {
            this.updateConfig();
        }
    }

    @Mod.EventBusSubscriber
    public static class ObjectRegistryHandler {
        @SubscribeEvent
        public static void addItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().register((IForgeRegistryEntry)ItemBlacklisted.I);
        }
    }

    @GameRegistry.ObjectHolder(value="forge")
    public static class Items {
        @GameRegistry.ObjectHolder(value="itemblacklisted")
        public static ItemBlacklisted itemItemBlacklisted;
    }
}

