/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.tools;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.base.BasicElectricItem;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import trinsdar.gravisuit.util.GravisuitLang;

public class ItemRelocator
extends BasicElectricItem {
    public ItemRelocator() {
        this.func_77655_b("relocator");
        this.func_77637_a(IC2.tabIC2);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(player)) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            TeleportMode teleportMode = TeleportMode.values()[nbt.func_74771_c("TeleportMode")];
            teleportMode = teleportMode.getNext();
            nbt.func_74774_a("TeleportMode", (byte)teleportMode.ordinal());
            if (teleportMode == TeleportMode.PERSONAL) {
                IC2.platform.messagePlayer(player, GravisuitLang.messageRelocatorPersonal);
            } else if (teleportMode == TeleportMode.PORTAL) {
                IC2.platform.messagePlayer(player, GravisuitLang.messageRelocatorPortal);
            } else {
                IC2.platform.messagePlayer(player, GravisuitLang.messageRelocatorTranslocator);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
        byte teleportMode = nbt.func_74771_c("TeleportMode");
        if (teleportMode == 0) {
            tooltip.add(GravisuitLang.toolMode.getLocalizedFormatted(new Object[]{GravisuitLang.relocatorPersonal}));
        } else if (teleportMode == 1) {
            tooltip.add(GravisuitLang.toolMode.getLocalizedFormatted(new Object[]{GravisuitLang.relocatorPortal}));
        } else if (teleportMode == 2) {
            tooltip.add(GravisuitLang.toolMode.getLocalizedFormatted(new Object[]{GravisuitLang.relocatorTranslocator}));
        }
        List<String> ctrlTip = sortedTooltip.get(ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(2), GravisuitLang.multiModes.getLocalized()}));
        tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.gravisuit.wip", (Object[])new Object[0]));
    }

    public int getTextureEntry(int i) {
        return 179;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return 1.0E8;
    }

    public int getTier(ItemStack stack) {
        return 5;
    }

    public double getTransferLimit(ItemStack stack) {
        return 50000.0;
    }

    public boolean canUse(ItemStack stack, int energy) {
        return ElectricItem.manager.canUse(stack, (double)energy);
    }

    public void useEnergy(ItemStack stack, int energy, EntityPlayer player) {
        ElectricItem.manager.use(stack, (double)energy, (EntityLivingBase)player);
    }

    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    public static enum TeleportMode {
        PERSONAL,
        PORTAL,
        TRANSLOCATOR;


        public TeleportMode getNext() {
            if (this == PERSONAL) {
                return PORTAL;
            }
            if (this == PORTAL) {
                return TRANSLOCATOR;
            }
            return PERSONAL;
        }
    }
}

