/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.items.armor;

import asmodeuscore.api.item.IItemPressurized;
import asmodeuscore.api.item.IItemRadiation;
import galaxyspace.api.item.IJetpackArmor;
import galaxyspace.api.item.IModificationItem;
import galaxyspace.core.client.models.ModelOBJArmor;
import galaxyspace.core.prefab.items.ItemElectricArmor;
import galaxyspace.core.prefab.items.modules.ItemModule;
import galaxyspace.core.util.GSCreativeTabs;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.items.modules.Energy;
import galaxyspace.systems.SolarSystem.planets.overworld.items.modules.Gravity;
import galaxyspace.systems.SolarSystem.planets.overworld.items.modules.Jetpack;
import galaxyspace.systems.SolarSystem.planets.overworld.items.modules.Jump;
import galaxyspace.systems.SolarSystem.planets.overworld.items.modules.Nightvision;
import galaxyspace.systems.SolarSystem.planets.overworld.items.modules.SensorLens;
import galaxyspace.systems.SolarSystem.planets.overworld.items.modules.Speed;
import galaxyspace.systems.SolarSystem.planets.overworld.items.modules.Stepassist;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemSpaceSuitModel;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.item.IArmorCorrosionResistant;
import micdoodle8.mods.galacticraft.api.item.IArmorGravity;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.api.item.ISensorGlassesArmor;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.gui.overlay.OverlaySensorGlasses;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemSpaceSuit
extends ItemElectricArmor
implements IArmorCorrosionResistant,
ISensorGlassesArmor,
IModificationItem,
IJetpackArmor,
ISpecialArmor,
IArmorGravity,
IItemPressurized,
IItemRadiation {
    private int tier = 0;
    public static String mod_count = "modification_count";
    public static String[] suit_buttons = new String[]{"helmet_button", "chest_button", "legs_button", "boots_button"};
    public static boolean[] pressedKey = new boolean[3];
    private boolean[] key_handler = new boolean[4];
    private float jumpCharge;

    public ItemSpaceSuit(ItemArmor.ArmorMaterial materialIn, EntityEquipmentSlot armorIndex, int tier) {
        super(materialIn, armorIndex);
        this.func_77655_b("space_suit_" + armorIndex.toString().toLowerCase());
        this.func_77656_e(200);
        this.setNoRepair();
        this.tier = tier;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b(mod_count)) {
            stack.func_77978_p().func_74768_a(mod_count, this.getModificationCount(stack));
        }
        switch (this.getArmorType(stack)) {
            case HEAD: {
                if (stack.func_77978_p().func_74764_b(suit_buttons[0])) break;
                stack.func_77978_p().func_74757_a(suit_buttons[0], false);
                break;
            }
            case CHEST: {
                if (stack.func_77978_p().func_74764_b(suit_buttons[1])) break;
                stack.func_77978_p().func_74757_a(suit_buttons[1], false);
                break;
            }
            case LEGS: {
                if (stack.func_77978_p().func_74764_b(suit_buttons[2])) break;
                stack.func_77978_p().func_74757_a(suit_buttons[2], false);
                break;
            }
            case FEET: {
                if (stack.func_77978_p().func_74764_b(suit_buttons[3])) break;
                stack.func_77978_p().func_74757_a(suit_buttons[3], false);
                break;
            }
        }
    }

    public int getTier() {
        return this.tier;
    }

    private void pressed() {
        Minecraft mc = Minecraft.func_71410_x();
        ItemSpaceSuit.pressedKey[0] = mc.field_71474_y.field_74314_A.func_151470_d();
        ItemSpaceSuit.pressedKey[1] = mc.field_71474_y.field_74351_w.func_151470_d();
        ItemSpaceSuit.pressedKey[2] = mc.field_71474_y.field_74311_E.func_151470_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks) {
        if (this.getArmorType(stack) == EntityEquipmentSlot.HEAD && stack.func_77978_p().func_74767_n("sensor") && this.getElectricityStored(stack) > 2.0f && stack.func_77978_p().func_74767_n(suit_buttons[0])) {
            OverlaySensorGlasses.renderSensorGlassesMain((ItemStack)stack, (EntityPlayer)player, (ScaledResolution)resolution, (float)partialTicks);
            OverlaySensorGlasses.renderSensorGlassesValueableBlocks((ItemStack)stack, (EntityPlayer)player, (ScaledResolution)resolution, (float)partialTicks);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        GCPlayerStats stats;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).shouldCorrodeArmor() && (stats = GCPlayerStats.get((Entity)player)).getShieldControllerInSlot().func_190926_b()) {
            this.discharge(itemStack, 50.0f, true);
        }
        if (world.field_72995_K) {
            this.pressed();
        }
        if (itemStack.func_77942_o()) {
            for (ItemModule modules : this.getAvailableModules()) {
                if (this.getArmorType(itemStack) != modules.getEquipmentSlot() || !itemStack.func_77978_p().func_74767_n(modules.getName()) || !(this.getElectricityStored(itemStack) >= (float)modules.getDischargeCount())) continue;
                modules.onUpdate(world, player, itemStack, itemStack.func_77978_p().func_74767_n(suit_buttons[3 - this.getArmorType(itemStack).func_188454_b()]));
                if (!itemStack.func_77978_p().func_74767_n(suit_buttons[3 - this.getArmorType(itemStack).func_188454_b()]) || player.field_70173_aa % 20 != 0) continue;
                this.discharge(itemStack, modules.getDischargeCount(), true);
            }
            if (this.getArmorType(itemStack) == EntityEquipmentSlot.FEET && itemStack.func_77978_p().func_74767_n(suit_buttons[3])) {
                if (pressedKey[0]) {
                    if (itemStack.func_77978_p().func_74767_n("jump") && this.getElectricityStored(itemStack) >= 5.0f) {
                        if (player.field_70122_E) {
                            this.jumpCharge = 1.0f;
                        }
                        if (player.field_70181_x >= 0.0 && this.jumpCharge > 0.0f && !player.func_70090_H()) {
                            player.field_70143_R = 0.3f;
                            this.discharge(itemStack, 5.0f, true);
                            player.field_70181_x += (double)(this.jumpCharge * 0.25f);
                            this.jumpCharge = (float)((double)this.jumpCharge * 0.75);
                        }
                    } else if (this.jumpCharge < 1.0f) {
                        this.jumpCharge = 0.0f;
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flagIn) {
        list.addAll(FMLClientHandler.instance().getClient().field_71466_p.func_78271_c(GCCoreUtil.translate((String)"gui.spacesuit.desc"), 250));
        if (this.getArmorType(stack).equals((Object)EntityEquipmentSlot.HEAD)) {
            list.add(EnumColor.DARK_GREEN + GCCoreUtil.translate((String)"gui.spacesuit_helmet.desc"));
        }
        String color = "";
        float joules = this.getElectricityStored(stack);
        color = joules <= this.getMaxElectricityStored(stack) / 3.0f ? "\u00a74" : (joules > this.getMaxElectricityStored(stack) * 2.0f / 3.0f ? "\u00a72" : "\u00a76");
        list.add(EnumColor.GREY + GCCoreUtil.translate((String)"gui.module.available_modules") + " " + stack.func_77978_p().func_74762_e(mod_count));
        list.add("");
        list.add(EnumColor.AQUA + GCCoreUtil.translate((String)"gui.module.list"));
        if (Keyboard.isKeyDown((int)42)) {
            for (ItemModule s : this.getAvailableModules()) {
                if (s.getEquipmentSlot() != this.getArmorType(stack) || !stack.func_77978_p().func_74764_b(s.getName())) continue;
                list.addAll(FMLClientHandler.instance().getClient().field_71466_p.func_78271_c(this.check(stack, s.getName()) + GCCoreUtil.translate((String)("gui.module." + s.getName())), 150));
            }
        } else {
            list.add(EnumColor.DARK_AQUA + GCCoreUtil.translateWithFormat((String)"item_desc.shift.name", (Object[])new Object[]{GameSettings.func_74298_c((int)FMLClientHandler.instance().getClient().field_71474_y.field_74311_E.func_151463_i())}));
        }
        list.add("");
        list.add(color + EnergyDisplayHelper.getEnergyDisplayS((float)joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS((float)this.getMaxElectricityStored(stack)));
    }

    private String check(ItemStack stack, String nbt) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n(nbt)) {
            return TextFormatting.DARK_GREEN + "- ";
        }
        return TextFormatting.DARK_RED + "- ";
    }

    private EntityEquipmentSlot getArmorType(ItemStack stack) {
        EntityEquipmentSlot i = EntityLiving.func_184640_d((ItemStack)stack);
        return i;
    }

    public void needText(EntityPlayer player, String text) {
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + GCCoreUtil.translate((String)("gui.message." + text))));
    }

    public void installText(EntityPlayer player, String text) {
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_GREEN + GCCoreUtil.translate((String)("gui.message.install." + text))));
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped model) {
        ItemSpaceSuitModel armorModel = armorSlot.equals((Object)EntityEquipmentSlot.CHEST) && itemStack.func_77942_o() && itemStack.func_77978_p().func_74767_n("jetpack") ? new ItemSpaceSuitModel(5) : new ItemSpaceSuitModel(armorSlot.func_188454_b());
        if (itemStack.func_77973_b() instanceof ItemSpaceSuit) {
            armorModel = ItemSpaceSuit.fillingArmorModel(armorModel, entityLiving);
            if (this.func_82816_b_(itemStack) && armorModel instanceof ModelOBJArmor) {
                ((ModelOBJArmor)armorModel).color = this.func_82814_b(itemStack);
            }
        }
        return armorModel;
    }

    public static ModelBiped fillingArmorModel(ModelBiped model, EntityLivingBase entityLiving) {
        if (model == null) {
            return model;
        }
        model.field_178722_k.field_78806_j = false;
        model.field_178721_j.field_78806_j = false;
        model.field_178724_i.field_78806_j = false;
        model.field_178723_h.field_78806_j = false;
        model.field_78115_e.field_78806_j = false;
        model.field_178720_f.field_78806_j = false;
        model.field_78116_c.field_78806_j = false;
        model.field_78117_n = entityLiving.func_70093_af();
        model.field_78093_q = entityLiving.func_184218_aH();
        model.field_78091_s = entityLiving.func_70631_g_();
        return model;
    }

    @Override
    public float getMaxElectricityStored(ItemStack stack) {
        boolean energy = stack.func_77942_o() && stack.func_77978_p().func_74764_b("energy");
        switch (this.getArmorType(stack).func_188454_b()) {
            case 0: {
                return energy ? 100000.0f : 25000.0f;
            }
            case 1: {
                return energy ? 150000.0f : 50000.0f;
            }
            case 2: {
                return energy ? 250000.0f : 75000.0f;
            }
            case 3: {
                return energy ? 50000.0f : 20000.0f;
            }
        }
        return 10000.0f;
    }

    public int gravityOverrideIfLow(EntityPlayer player) {
        if (!((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_190926_b() && !((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_77942_o()) {
            ((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_77982_d(new NBTTagCompound());
        }
        return !((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_77978_p().func_74767_n(suit_buttons[3]) && ((ItemStack)player.field_71071_by.field_70460_b.get(0)).func_77978_p().func_74767_n("gravity") && this.getElectricityStored((ItemStack)player.field_71071_by.field_70460_b.get(0)) > 0.0f ? 100 : 0;
    }

    public int gravityOverrideIfHigh(EntityPlayer p) {
        return 0;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        return new ISpecialArmor.ArmorProperties(1, 0.16, Integer.MAX_VALUE);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        this.discharge(stack, 5.0f, true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == GSCreativeTabs.GSArmorTab || tab == CreativeTabs.field_78027_g) {
            list.add((Object)new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 3070171;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public void consumeFuel(ItemStack stack, int fuel) {
        this.discharge(stack, 5.0f, true);
    }

    @Override
    public void decrementFuel(ItemStack stack) {
        if (stack.func_77973_b() instanceof IItemElectric) {
            ((IItemElectric)stack.func_77973_b()).discharge(stack, 1.0f, true);
        }
    }

    @Override
    public int getFuel(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("jetpack:fuel");
    }

    @Override
    public boolean canFly(ItemStack stack, EntityPlayer player) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("jetpack") && stack.func_77978_p().func_74767_n(suit_buttons[1]) && stack.func_77952_i() < stack.func_77958_k();
    }

    @Override
    public boolean isActivated(ItemStack stack) {
        return stack.func_77978_p().func_74767_n("jetpack:activated");
    }

    @Override
    public void switchState(ItemStack stack, boolean state) {
        if (!stack.func_190926_b() && stack.func_77942_o()) {
            stack.func_77978_p().func_74757_a("jetpack:activated", state);
        } else {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    @Override
    public int getFireStreams(ItemStack stack) {
        return 2;
    }

    public float getSolarRadiationProtectModify() {
        return 1.0f;
    }

    @Override
    public GSUtils.Module_Type getType(ItemStack stack) {
        return GSUtils.Module_Type.SPACESUIT;
    }

    @Override
    public ItemModule[] getAvailableModules() {
        return new ItemModule[]{new SensorLens(), new Nightvision(), new Jetpack(), new Speed(), new Gravity(), new Stepassist(), new Jump(), new Energy()};
    }

    @Override
    public int getModificationCount(ItemStack stack) {
        return 2;
    }

    public int func_77619_b() {
        return 0;
    }
}

