/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.items;

import ic2.core.block.machine.high.TileEntityUraniumEnricher;
import ic2.core.item.reactor.base.ItemUraniumRodBase;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.IC2CExtras;
import trinsdar.ic2c_extras.items.urantypes.MOX;
import trinsdar.ic2c_extras.items.urantypes.Plutonium;
import trinsdar.ic2c_extras.items.urantypes.Thorium230;
import trinsdar.ic2c_extras.items.urantypes.Thorium232;
import trinsdar.ic2c_extras.items.urantypes.UOX;

public class ItemNuclearRod
extends ItemUraniumRodBase {
    NuclearRodTypes type;
    NuclearRodVariants variant;
    private int index;
    public static IUranium[] types = new IUranium[0];

    public ItemNuclearRod(NuclearRodTypes type, NuclearRodVariants variant) {
        this.type = type;
        this.variant = variant;
        String name = type.getPrefix() + variant.getPrefix();
        this.setRegistryName("ic2c_extras", name.toLowerCase() + "cell");
        this.func_77637_a(IC2CExtras.creativeTab);
        this.setUnlocalizedName((LocaleComp)new LangComponentHolder.LocaleItemComp("item." + name + "Cell"));
    }

    public static void init() {
        types = new IUranium[5];
        ItemNuclearRod.types[0] = new UOX();
        ItemNuclearRod.types[1] = new Plutonium();
        ItemNuclearRod.types[2] = new MOX();
        ItemNuclearRod.types[3] = new Thorium232();
        ItemNuclearRod.types[4] = new Thorium230();
        TileEntityUraniumEnricher.RECIPE_LIST.add(types[0]);
    }

    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return ItemNuclearRod.getUran(this.variant).getTexture(this.getRodType(this.type));
    }

    public LocaleComp getLangComponent(ItemStack stack) {
        return this.name;
    }

    public IUranium getUranium(ItemStack stack) {
        return ItemNuclearRod.getUran(this.variant);
    }

    public IUranium.RodType getRodType(ItemStack itemStack) {
        return this.getRodType(this.type);
    }

    public ItemStack[] getSubParts() {
        return new ItemStack[0];
    }

    public boolean hasSubParts() {
        return false;
    }

    public ItemStack getReactorPart() {
        return ItemNuclearRod.getUran(this.variant).getRodType(this.getRodType(this.type));
    }

    public short getID(ItemStack stack) {
        return ItemNuclearRod.getUran(this.variant).getRodID(this.getRodType(this.type));
    }

    public IUranium.RodType getRodType(int metadata) {
        return this.getRodType(this.type);
    }

    public IUranium.RodType getRodType(NuclearRodTypes type) {
        if (type == NuclearRodTypes.SINGLE) {
            return IUranium.RodType.SingleRod;
        }
        if (type == NuclearRodTypes.DOUBLE) {
            return IUranium.RodType.DualRod;
        }
        if (type == NuclearRodTypes.QUAD) {
            return IUranium.RodType.QuadRod;
        }
        return IUranium.RodType.SingleRod;
    }

    public static IUranium getUran(NuclearRodVariants variant) {
        if (variant == NuclearRodVariants.UOX) {
            return types[0];
        }
        if (variant == NuclearRodVariants.PLUTONIUM) {
            return types[1];
        }
        if (variant == NuclearRodVariants.MOX) {
            return types[2];
        }
        if (variant == NuclearRodVariants.THORIUM232) {
            return types[3];
        }
        if (variant == NuclearRodVariants.THORIUM230) {
            return types[4];
        }
        return types[0];
    }

    public int getRodAmount(ItemStack stack) {
        return (int)this.getRodAmount(this.type);
    }

    public IUranium getUranium(int i) {
        return ItemNuclearRod.getUran(this.variant);
    }

    public float getRodAmount(NuclearRodTypes type) {
        if (type == NuclearRodTypes.SINGLE) {
            return 1.0f;
        }
        if (type == NuclearRodTypes.DOUBLE) {
            return 2.0f;
        }
        if (type == NuclearRodTypes.QUAD) {
            return 4.0f;
        }
        return 1.0f;
    }

    public int getTextureEntry(int i) {
        return 0;
    }

    public static enum NuclearRodVariants {
        UOX("UOX"),
        PLUTONIUM("Plutonium"),
        MOX("MOX"),
        THORIUM232("Thorium232"),
        THORIUM230("Thorium230");

        private String prefix;

        private NuclearRodVariants(String name) {
            this.prefix = name;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    public static enum NuclearRodTypes {
        SINGLE("single"),
        DOUBLE("double"),
        QUAD("quad");

        private String prefix;

        private NuclearRodTypes(String name) {
            this.prefix = name;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

