/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.ISmartFluidSync;
import me.desht.pneumaticcraft.common.tileentity.TileEntityOmnidirectionalHopper;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityLiquidHopper
extends TileEntityOmnidirectionalHopper
implements ISerializableTanks,
ISmartFluidSync {
    private int comparatorValue = -1;
    @LazySynced
    @DescSynced
    @GuiSynced
    private final HopperTank tank;
    @DescSynced
    private int fluidAmountScaled;
    private final WrappedFluidTank inputWrapper;
    private final WrappedFluidTank outputWrapper;

    public TileEntityLiquidHopper() {
        if (ConfigHandler.machineProperties.liquidHopperDispenser) {
            this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.DISPENSER);
        }
        this.tank = new HopperTank(this, 16000);
        this.inputWrapper = new WrappedFluidTank(this.tank, true);
        this.outputWrapper = new WrappedFluidTank(this.tank, false);
    }

    @Override
    protected int getInvSize() {
        return 0;
    }

    @Override
    public String getName() {
        return Blockss.LIQUID_HOPPER.func_149739_a();
    }

    @Override
    protected int getComparatorValueInternal() {
        if (this.comparatorValue < 0) {
            if (this.tank.getFluidAmount() == 0) {
                return 0;
            }
            FluidStack fluidStack = this.tank.getFluid();
            this.comparatorValue = (int)(1.0f + (float)fluidStack.amount / (float)this.tank.getCapacity() * 14.0f);
        }
        return this.comparatorValue;
    }

    @Override
    protected boolean doExport(int maxItems) {
        Block fluidBlock;
        FluidStack extractedFluid;
        Object neighbor;
        EnumFacing dir = this.getRotation();
        if (this.tank.getFluid() != null && (neighbor = this.getCachedNeighbor(dir)) != null && neighbor.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())) {
            int amount;
            IFluidHandler fluidHandler = (IFluidHandler)neighbor.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d());
            FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.tank, (int)(amount = Math.min(maxItems * 100, this.tank.getFluid().amount - this.leaveMaterialCount * 1000)), (boolean)true);
            return transferred != null && transferred.amount > 0;
        }
        if (this.func_145831_w().func_175623_d(this.func_174877_v().func_177972_a(dir))) {
            for (EntityItem entity : TileEntityLiquidHopper.getNeighborItems(this, dir)) {
                NonNullList returnedItems = NonNullList.func_191196_a();
                if (!FluidUtils.tryFluidExtraction((IFluidHandler)this.tank, entity.func_92059_d(), (NonNullList<ItemStack>)returnedItems)) continue;
                if (entity.func_92059_d().func_190916_E() <= 0) {
                    entity.func_70106_y();
                }
                for (ItemStack stack : returnedItems) {
                    EntityItem item = new EntityItem(this.func_145831_w(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
                    item.field_70159_w = entity.field_70159_w;
                    item.field_70181_x = entity.field_70181_x;
                    item.field_70179_y = entity.field_70179_y;
                    this.func_145831_w().func_72838_d((Entity)item);
                }
                return true;
            }
        }
        if (ConfigHandler.machineProperties.liquidHopperDispenser && this.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) > 0 && this.func_145831_w().func_175623_d(this.func_174877_v().func_177972_a(dir)) && (extractedFluid = this.tank.drain(1000, false)) != null && extractedFluid.amount == 1000 && (fluidBlock = extractedFluid.getFluid().getBlock()) != null) {
            this.tank.drain(1000, true);
            this.func_145831_w().func_175656_a(this.func_174877_v().func_177972_a(dir), fluidBlock.func_176223_P());
        }
        return false;
    }

    @Override
    protected boolean doImport(int maxItems) {
        int filledFluid;
        Object fluidHandler;
        FluidStack fluid;
        TileEntity inputInv = this.getCachedNeighbor(this.inputDir);
        if (inputInv != null && inputInv.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.inputDir.func_176734_d()) && (fluid = (fluidHandler = (IFluidHandler)inputInv.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.inputDir.func_176734_d())).drain(maxItems * 100, false)) != null && (filledFluid = this.tank.fill(fluid, true)) > 0) {
            fluidHandler.drain(filledFluid, true);
            return true;
        }
        if (this.func_145831_w().func_175623_d(this.func_174877_v().func_177972_a(this.inputDir))) {
            for (EntityItem entity : TileEntityLiquidHopper.getNeighborItems(this, this.inputDir)) {
                NonNullList returnedItems = NonNullList.func_191196_a();
                if (!FluidUtils.tryFluidInsertion((IFluidHandler)this.tank, entity.func_92059_d(), (NonNullList<ItemStack>)returnedItems)) continue;
                if (entity.func_92059_d().func_190926_b()) {
                    entity.func_70106_y();
                }
                for (ItemStack stack : returnedItems) {
                    EntityItem item = new EntityItem(this.func_145831_w(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
                    item.field_70159_w = entity.field_70159_w;
                    item.field_70181_x = entity.field_70181_x;
                    item.field_70179_y = entity.field_70179_y;
                    this.func_145831_w().func_72838_d((Entity)item);
                }
                return true;
            }
        }
        if (ConfigHandler.machineProperties.liquidHopperDispenser && this.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) > 0) {
            BlockPos neighborPos = this.func_174877_v().func_177972_a(this.inputDir);
            FluidStack fluidStack = FluidUtils.getFluidAt(this.func_145831_w(), neighborPos, false);
            if (fluidStack != null && fluidStack.amount == 1000 && this.tank.fill(fluidStack, false) == 1000) {
                this.tank.fill(fluidStack, true);
                FluidUtils.getFluidAt(this.func_145831_w(), neighborPos, true);
                return true;
            }
        }
        return false;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public EnumFacing getInputDirection() {
        return this.inputDir;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("tank", (NBTBase)tankTag);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.fluidAmountScaled = this.tank.getScaledFluidAmount();
        this.comparatorValue = -1;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == this.inputDir) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.inputWrapper);
            }
            if (facing == this.getRotation()) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.outputWrapper);
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return null;
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)((Object)this.tank));
    }

    @Override
    public void updateScaledFluidAmount(int tankIndex, int amount) {
        this.fluidAmountScaled = amount;
    }

    @Override
    protected void onUpgradesChanged() {
        FluidStack fluidStack;
        super.onUpgradesChanged();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.getUpgrades(IItemRegistry.EnumUpgrade.CREATIVE) > 0 && (fluidStack = this.tank.getFluid()) != null && fluidStack.amount > 0) {
            this.tank.setFluid(new FluidStack(fluidStack.getFluid(), 16000));
        }
    }

    class WrappedFluidTank
    implements IFluidTank,
    IFluidHandler {
        private final FluidTank wrappedTank;
        private final boolean inbound;

        WrappedFluidTank(FluidTank wrappedTank, boolean inbound) {
            this.wrappedTank = wrappedTank;
            this.inbound = inbound;
        }

        @Nullable
        public FluidStack getFluid() {
            return this.wrappedTank.getFluid();
        }

        public int getFluidAmount() {
            return this.wrappedTank.getFluidAmount();
        }

        public int getCapacity() {
            return this.wrappedTank.getCapacity();
        }

        public FluidTankInfo getInfo() {
            return this.wrappedTank.getInfo();
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.wrappedTank.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this.inbound ? this.wrappedTank.fill(resource, doFill) : 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.inbound ? null : TileEntityLiquidHopper.this.tank.drain(resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.inbound ? null : this.wrappedTank.drain(maxDrain, doDrain);
        }
    }

    class HopperTank
    extends ISmartFluidSync.SmartSyncTank {
        HopperTank(ISmartFluidSync holder, int capacity) {
            super(holder, capacity);
        }

        @Override
        protected void onContentsChanged() {
            super.onContentsChanged();
            TileEntityLiquidHopper.this.comparatorValue = -1;
        }

        public int fill(FluidStack resource, boolean doFill) {
            int filled = super.fill(resource, doFill);
            if (TileEntityLiquidHopper.this.isCreative && this.getFluidAmount() > 0 && this.getFluid().getFluid() == resource.getFluid()) {
                return resource.amount;
            }
            return filled;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return super.drain(resource, !TileEntityLiquidHopper.this.isCreative && doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return super.drain(maxDrain, !TileEntityLiquidHopper.this.isCreative && doDrain);
        }
    }
}

