/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching.matcher;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import wanion.lib.common.matching.Matching;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.AnyDamageMatcher;
import wanion.lib.common.matching.matcher.ItemStackMatcher;
import wanion.lib.common.matching.matcher.NbtMatcher;
import wanion.lib.common.matching.matcher.OreDictMatcher;

public enum MatcherEnum {
    ITEM_STACK(ItemStackMatcher.class),
    ANY_DAMAGE(AnyDamageMatcher.class),
    NBT(NbtMatcher.class),
    ORE_DICT(OreDictMatcher.class);

    final Class<? extends AbstractMatcher> matcherClass;

    private MatcherEnum(Class<? extends AbstractMatcher> matcherClass) {
        this.matcherClass = matcherClass;
    }

    @Nonnull
    public AbstractMatcher getMatcher(@Nonnull Matching matching) {
        try {
            Constructor<? extends AbstractMatcher> constructor = this.matcherClass.getDeclaredConstructor(Matching.class);
            return constructor.newInstance(matching);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("This Should never happen: " + e);
        }
    }
}

