/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockGasBurner;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlock;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityGasBurner
extends TileBaseElectricBlock
implements IFluidHandlerWrapper,
ISidedInventory,
IPacketReceiver {
    public static final int PROCESS_TIME_REQUIRED_BASE = 20;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = 20;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private final int tankCapacity = 3000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank gasTank = new FluidTank(this.tankCapacity);

    public TileEntityGasBurner() {
        super("tile.gas_burner.name");
        this.storage.setCapacity(15000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 45.0f : 25.0f);
        this.setTierGC(1);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun) {
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else if (--this.processTicks <= 0) {
                        this.smeltItem();
                        this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    public boolean canProcess() {
        return this.gasTank.getFluidAmount() > 0;
    }

    public void smeltItem() {
        if (OxygenUtil.isAABBInBreathableAirBlock((World)this.field_145850_b, (AxisAlignedBB)new AxisAlignedBB(this.func_174877_v().func_177982_a(0, 1, 0)))) {
            this.field_145850_b.func_175656_a(this.func_174877_v().func_177984_a(), Blocks.field_150480_ab.func_176223_P());
        }
        this.gasTank.drain(100, true);
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        if (par1NBTTagCompound.func_74764_b("gasTank")) {
            this.gasTank.readFromNBT(par1NBTTagCompound.func_74775_l("gasTank"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        if (this.gasTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("gasTank", (NBTBase)this.gasTank.writeToNBT(new NBTTagCompound()));
        }
        return par1NBTTagCompound;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from == this.getPipe() && fluid.isGaseous()) {
            return this.gasTank.getFluid() == null || this.gasTank.getFluidAmount() < this.gasTank.getCapacity();
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (resource != null && this.canFill(from, resource.getFluid()) && from == this.getPipe() && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null) {
            used = this.gasTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.gasTank)};
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockGasBurner) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockGasBurner.FACING);
        }
        return EnumFacing.NORTH;
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            EnumFacing pipeSide = this.getPipe();
            return direction == pipeSide;
        }
        return false;
    }

    private EnumFacing getPipe() {
        return this.getFront().func_176735_f();
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.DOWN;
    }

    public int getScaledTankLevel(int i) {
        return this.gasTank.getFluidAmount() * i / this.gasTank.getCapacity();
    }

    public int[] func_180463_a(EnumFacing side) {
        return null;
    }
}

