/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.render.modelspec;

import javax.annotation.Nullable;
import net.machinemuse.numina.client.model.helper.MuseModelHelper;
import net.machinemuse.numina.client.model.obj.MuseOBJModel;
import net.machinemuse.numina.client.render.modelspec.ModelSpec;
import net.machinemuse.numina.client.render.modelspec.PartSpecBase;
import net.machinemuse.numina.client.render.modelspec.SpecBase;
import net.machinemuse.numina.map.MuseRegistry;
import net.machinemuse.numina.string.MuseStringUtils;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class ModelRegistry
extends MuseRegistry<SpecBase> {
    private static volatile ModelRegistry INSTANCE;

    private ModelRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModelRegistry getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ModelRegistry> clazz = ModelRegistry.class;
        synchronized (ModelRegistry.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ModelRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Nullable
    public static MuseOBJModel.MuseOBJBakedModel wrap(ResourceLocation modelLocation, IModelState modelState) {
        IBakedModel bakedModel = MuseModelHelper.getBakedOBJModel(modelLocation, modelState);
        return bakedModel instanceof MuseOBJModel.MuseOBJBakedModel ? (MuseOBJModel.MuseOBJBakedModel)bakedModel : null;
    }

    public MuseOBJModel.MuseOBJBakedModel loadBakedModel(ResourceLocation resource, IModelState modelState) {
        String name = MuseStringUtils.extractName(resource);
        SpecBase spec = (SpecBase)this.get(name);
        if (spec == null) {
            return ModelRegistry.wrap(resource, modelState);
        }
        return ((ModelSpec)spec).getModel();
    }

    public Iterable<SpecBase> getSpecs() {
        return this.elems();
    }

    public Iterable<String> getNames() {
        return this.names();
    }

    public SpecBase getModel(NBTTagCompound nbt) {
        return (SpecBase)this.get(nbt.func_74779_i("model"));
    }

    public PartSpecBase getPart(NBTTagCompound nbt, SpecBase model) {
        return (PartSpecBase)model.get(nbt.func_74779_i("part"));
    }

    public PartSpecBase getPart(NBTTagCompound nbt) {
        return this.getPart(nbt, this.getModel(nbt));
    }

    public NBTTagCompound getSpecTag(NBTTagCompound museRenderTag, PartSpecBase spec) {
        String name = this.makeName(spec);
        return museRenderTag.func_74764_b(name) ? museRenderTag.func_74775_l(name) : null;
    }

    public String makeName(PartSpecBase spec) {
        return spec.spec.getOwnName() + "." + spec.partName;
    }
}

