/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.tile.TileInteractionProxy;
import com.rwtema.extrautils2.utils.Lang;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInteractionProxy
extends XUBlockStatic {
    public BlockInteractionProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        BoxModel model = new BoxModel();
        model.addBoxI(2, 2, 2, 14, 14, 14);
        model.addBoxI(0, 2, 0, 16, 2, 16);
        model.addBoxI(0, 14, 0, 16, 14, 16);
        model.addBoxI(2, 0, 0, 2, 16, 16);
        model.addBoxI(14, 0, 0, 14, 16, 16);
        model.addBoxI(0, 0, 2, 16, 16, 2);
        model.addBoxI(0, 0, 14, 16, 16, 14);
        model.setTexture("ender_pearl_construct");
        model.setLayer(BlockRenderLayer.CUTOUT);
        return model;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, playerIn, tooltip, advanced);
        tooltip.add(Lang.translate("Acts as a portal to a remote block location."));
        tooltip.add(Lang.translate("Use the GUI to specify a range of blocks from which the remote block is chosen."));
        tooltip.add(Lang.translate("The remote block changes once per second."));
        tooltip.add(Lang.translate("'Mechanical Users', 'Mechanical Miners' and 'Scanners' interact with the remote block."));
        tooltip.add(Lang.translate("In addition, items/fluids/energy can travel through the portal"));
        tooltip.add(Lang.translate("Requires GP, proportional to the distance covered by the portal."));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileInteractionProxy();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onSelect(DrawBlockHighlightEvent event) {
        RayTraceResult movingObjectPositionIn = event.getTarget();
        if (movingObjectPositionIn.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = movingObjectPositionIn.func_178782_a();
            EntityPlayer player = event.getPlayer();
            IBlockState iblockstate = player.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() == this) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187441_d((float)2.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)false);
                TileEntity tileEntity = player.field_70170_p.func_175625_s(blockpos);
                if (!(tileEntity instanceof TileInteractionProxy)) {
                    return;
                }
                TileInteractionProxy proxy = (TileInteractionProxy)tileEntity;
                float partialTicks = event.getPartialTicks();
                double d3 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
                double d4 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
                double d5 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
                AxisAlignedBB union = new AxisAlignedBB((BlockPos)proxy.targetA).func_111270_a(new AxisAlignedBB((BlockPos)proxy.targetB));
                RenderGlobal.func_189697_a((AxisAlignedBB)union.func_186662_g((double)0.002f).func_186670_a(blockpos).func_72317_d(-d3, -d4, -d5), (float)0.54901963f, (float)0.95686275f, (float)0.8862745f, (float)0.4f);
                union = new AxisAlignedBB((BlockPos)proxy.currentPos);
                RenderGlobal.func_189697_a((AxisAlignedBB)union.func_186662_g((double)0.002f).func_186670_a(blockpos).func_72317_d(-d3, -d4, -d5), (float)0.54901963f, (float)0.95686275f, (float)0.8862745f, (float)0.4f);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
            }
        }
    }
}

