/*
 * Decompiled with CFR 0.152.
 */
package openblocks.enchantments;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openmods.OpenMods;

public class ExplosiveEnchantmentsHandler {
    private static final double VERTICAL_FACTOR = 5.0;
    private final List<EntityEquipmentSlot> protectionParts = Lists.newArrayList((Object[])new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.HEAD});
    private static final Set<String> ALLOWED_DAMAGE_SOURCE = ImmutableSet.of((Object)"arrow", (Object)"player", (Object)"mob");
    private static final EnchantmentLevel[] LEVELS = new EnchantmentLevel[]{new EnchantmentLevel(0.1, 5.0, 5.0f, 1.0f, false, 1), new EnchantmentLevel(0.75, 7.5, 10.0f, 2.0f, false, 2), new EnchantmentLevel(1.0, 10.0, 5.0f, 4.0f, Config.explosiveEnchantGrief, 4)};
    private Map<Entity, JumpInfo> jumpBoosts = new MapMaker().weakKeys().makeMap();
    private static final ItemStack gunpowder = new ItemStack(Items.field_151016_H);

    public static void createExplosionForEntity(Entity entity, float power, boolean isDestructive) {
        if (!entity.field_70170_p.field_72995_K) {
            entity.field_70170_p.func_72876_a(entity, entity.field_70165_t, entity.func_174813_aQ().field_72338_b, entity.field_70161_v, power, isDestructive);
        }
    }

    private static void useItems(EntityPlayer player, @Nonnull ItemStack resource, EntityEquipmentSlot armorSlot, int gunpowderAmout) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack armor = player.func_184582_a(armorSlot);
        armor.func_77972_a(1, (EntityLivingBase)player);
        resource.func_190918_g(gunpowderAmout);
    }

    private static EnchantmentLevel tryUseEnchantment(EntityPlayer player, EntityEquipmentSlot slot) {
        ItemStack armor = player.func_184582_a(slot);
        if (armor.func_190926_b() || !(armor.func_77973_b() instanceof ItemArmor)) {
            return null;
        }
        InventoryPlayer inventory = player.field_71071_by;
        int explosiveLevel = EnchantmentHelper.func_77506_a((Enchantment)OpenBlocks.Enchantments.explosive, (ItemStack)armor);
        if (explosiveLevel <= 0 || explosiveLevel > LEVELS.length) {
            return null;
        }
        EnchantmentLevel level = LEVELS[explosiveLevel - 1];
        for (ItemStack stack : inventory.field_70462_a) {
            if (!gunpowder.func_77969_a(stack) || stack.func_190916_E() < level.gunpowderNeeded) continue;
            ExplosiveEnchantmentsHandler.useItems(player, stack, slot, level.gunpowderNeeded);
            return level;
        }
        return null;
    }

    private EnchantmentLevel tryUseUpperArmor(EntityPlayer player) {
        for (EntityEquipmentSlot armorPart : this.protectionParts) {
            EnchantmentLevel result = ExplosiveEnchantmentsHandler.tryUseEnchantment(player, armorPart);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent evt) {
        EntityLivingBase e = evt.getEntityLiving();
        if (evt.getDistance() > 4.0f && !e.func_70093_af() && e instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e;
            EnchantmentLevel level = ExplosiveEnchantmentsHandler.tryUseEnchantment(player, EntityEquipmentSlot.FEET);
            if (level == null) {
                return;
            }
            JumpInfo boost = new JumpInfo(level, evt.getDistance());
            level.createJumpExplosion((Entity)player);
            if (OpenMods.proxy.isClientPlayer((Entity)player)) {
                KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151463_i(), (boolean)true);
                this.jumpBoosts.put((Entity)player, boost);
            }
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent e) {
        Entity entity = e.getEntity();
        JumpInfo boost = this.jumpBoosts.remove(entity);
        if (boost != null) {
            boost.modifyVelocity(entity);
            if (OpenMods.proxy.isClientPlayer(entity)) {
                KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151463_i(), (boolean)false);
            }
        }
    }

    private static boolean checkSource(DamageSource source) {
        return source instanceof EntityDamageSource && ALLOWED_DAMAGE_SOURCE.contains(source.field_76373_n);
    }

    @SubscribeEvent
    public void onDamage(LivingAttackEvent e) {
        EnchantmentLevel level;
        Entity victim = e.getEntity();
        if (victim instanceof EntityPlayerMP && ExplosiveEnchantmentsHandler.checkSource(e.getSource()) && (level = this.tryUseUpperArmor((EntityPlayer)victim)) != null) {
            level.createArmorExplosion(victim);
        }
    }

    private static class JumpInfo {
        public final EnchantmentLevel level;
        public final float height;

        private JumpInfo(EnchantmentLevel level, float height) {
            this.level = level;
            this.height = height;
        }

        public void modifyVelocity(Entity entity) {
            double multiplier = this.level.calculateMultipler(this.height);
            entity.field_70159_w *= multiplier * 5.0;
            entity.field_70179_y *= multiplier * 5.0;
            entity.field_70181_x *= multiplier;
        }
    }

    private static class EnchantmentLevel {
        public final double multiplier;
        public final double maxHeightBonus;
        public final float jumpExplosionPower;
        public final float armorExplosionPower;
        public final boolean isDestructive;
        public final int gunpowderNeeded;

        private EnchantmentLevel(double multiplier, double maxHeightBonus, float jumpExplosionPower, float armorExplosionPower, boolean isDestructive, int gunpowderNeeded) {
            this.multiplier = multiplier;
            this.maxHeightBonus = maxHeightBonus;
            this.jumpExplosionPower = jumpExplosionPower;
            this.armorExplosionPower = armorExplosionPower;
            this.isDestructive = isDestructive;
            this.gunpowderNeeded = gunpowderNeeded;
        }

        protected double calculateHeightBonus(float height) {
            return Math.min(Math.sqrt(height), this.maxHeightBonus);
        }

        public double calculateMultipler(float height) {
            return this.multiplier + this.calculateHeightBonus(height);
        }

        public void createJumpExplosion(Entity entity) {
            ExplosiveEnchantmentsHandler.createExplosionForEntity(entity, this.jumpExplosionPower, this.isDestructive);
        }

        public void createArmorExplosion(Entity entity) {
            ExplosiveEnchantmentsHandler.createExplosionForEntity(entity, this.armorExplosionPower, this.isDestructive);
        }
    }
}

