/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building;

import com.direwolf20.buildinggadgets.common.building.IBlockProvider;
import com.direwolf20.buildinggadgets.common.building.IPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.IValidatorFactory;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.function.BiPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Context {
    private final IPlacementSequence positions;
    private final IBlockProvider blocks;
    private final IValidatorFactory validatorFactory;

    public Context(IPlacementSequence positions, IBlockProvider blocks) {
        this(positions, blocks, (world, stack, player, initial) -> (pos, state) -> true);
    }

    public Context(IPlacementSequence positions, IBlockProvider blocks, IValidatorFactory validatorFactory) {
        this.positions = positions;
        this.blocks = blocks;
        this.validatorFactory = validatorFactory;
    }

    public IPlacementSequence getPositionSequence() {
        return this.positions;
    }

    public Iterator<BlockPos> getFilteredSequence(World world, ItemStack stack, EntityPlayer player, BlockPos initial) {
        final Iterator<BlockPos> positions = this.getPositionSequence().iterator();
        final BiPredicate<BlockPos, IBlockState> validator = this.validatorFactory.createValidatorFor(world, stack, player, initial);
        return new AbstractIterator<BlockPos>(){

            protected BlockPos computeNext() {
                while (positions.hasNext()) {
                    BlockPos next = (BlockPos)positions.next();
                    if (!validator.test(next, Context.this.blocks.at(next))) continue;
                    return next;
                }
                return (BlockPos)this.endOfData();
            }
        };
    }

    public ImmutableList<BlockPos> collectFilteredSequence(World world, ItemStack stack, EntityPlayer player, BlockPos initial) {
        return ImmutableList.copyOf(this.getFilteredSequence(world, stack, player, initial));
    }

    public IBlockProvider getBlockProvider() {
        return this.blocks;
    }

    public IValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }
}

