/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiCompactor;
import cofh.thermalexpansion.gui.container.machine.ContainerCompactor;
import cofh.thermalexpansion.util.managers.machine.CompactorManager;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileCompactor
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.COMPACTOR.getMetadata();
    public static int basePower = 20;
    CompactorManager.CompactorRecipe curRecipe;
    private int inputTracker;
    private int outputTracker;
    private CompactorManager.Mode mode = CompactorManager.Mode.PLATE;
    protected boolean augmentMint;
    protected boolean augmentGear;

    public static void initialize() {
        TileCompactor.SIDE_CONFIGS[TileCompactor.TYPE] = new SideConfig();
        TileCompactor.SIDE_CONFIGS[TileCompactor.TYPE].numConfig = 5;
        TileCompactor.SIDE_CONFIGS[TileCompactor.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, {0, 1}, {0, 1}};
        TileCompactor.SIDE_CONFIGS[TileCompactor.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileCompactor.SIDE_CONFIGS[TileCompactor.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileCompactor.ALT_SIDE_CONFIGS[TileCompactor.TYPE] = new SideConfig();
        TileCompactor.ALT_SIDE_CONFIGS[TileCompactor.TYPE].numConfig = 2;
        TileCompactor.ALT_SIDE_CONFIGS[TileCompactor.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, {0, 1}, {0, 1}};
        TileCompactor.ALT_SIDE_CONFIGS[TileCompactor.TYPE].sideTypes = new int[]{0, 7};
        TileCompactor.ALT_SIDE_CONFIGS[TileCompactor.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileCompactor.SLOT_CONFIGS[TileCompactor.TYPE] = new SlotConfig();
        TileCompactor.SLOT_CONFIGS[TileCompactor.TYPE].allowInsertionSlot = new boolean[]{true, false, false};
        TileCompactor.SLOT_CONFIGS[TileCompactor.TYPE].allowExtractionSlot = new boolean[]{false, true, false};
        TileCompactor.VALID_AUGMENTS[TileCompactor.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineCompactorCoin");
        VALID_AUGMENTS[TYPE].add("machineCompactorGear");
        GameRegistry.registerTileEntity(TileCompactor.class, (String)"thermalexpansion:machine_compactor");
        TileCompactor.config();
    }

    public static void config() {
        String category = "Machine.Compactor";
        BlockMachine.enable[TileCompactor.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Compactor. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 5000, comment);
        TileCompactor.ENERGY_CONFIGS[TileCompactor.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileCompactor() {
        this.inventory = new ItemStack[3];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        CompactorManager.CompactorRecipe recipe = CompactorManager.getRecipe(this.inventory[0], this.mode);
        if (recipe == null) {
            return false;
        }
        if (this.inventory[0].func_190916_E() < recipe.getInput().func_190916_E()) {
            return false;
        }
        ItemStack output = recipe.getOutput();
        return this.inventory[1].func_190926_b() || this.inventory[1].func_77969_a(output) && this.inventory[1].func_190916_E() + output.func_190916_E() <= output.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        CompactorManager.CompactorRecipe recipe = CompactorManager.getRecipe(this.inventory[0], this.mode);
        return recipe != null && recipe.getInput().func_190916_E() <= this.inventory[0].func_190916_E();
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = CompactorManager.getRecipe(this.inventory[0], this.mode).getEnergy() * this.energyMod / 100;
    }

    @Override
    protected void processFinish() {
        CompactorManager.CompactorRecipe recipe = CompactorManager.getRecipe(this.inventory[0], this.mode);
        if (recipe == null) {
            this.processOff();
            return;
        }
        ItemStack output = recipe.getOutput();
        if (this.inventory[1].func_190926_b()) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)output);
        } else {
            this.inventory[1].func_190917_f(output.func_190916_E());
        }
        this.inventory[0].func_190918_g(recipe.getInput().func_190916_E());
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        if (this.inventory[1].func_190926_b()) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(1, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCompactor(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCompactor(inventory, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        return nbt;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.augmentMint);
        payload.addBool(this.augmentGear);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.augmentMint = payload.getBool();
        this.augmentGear = payload.getBool();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentMint = false;
        this.augmentGear = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (!this.augmentMint && !this.augmentGear) {
            if (this.mode != CompactorManager.Mode.PLATE && this.isActive && !this.inventory[1].func_190926_b()) {
                this.processOff();
            }
            this.mode = CompactorManager.Mode.PLATE;
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentMint && "machineCompactorCoin".equals(id)) {
            this.augmentMint = true;
            if (this.mode != CompactorManager.Mode.COIN && this.isActive && !this.inventory[1].func_190926_b()) {
                this.processOff();
            }
            this.mode = CompactorManager.Mode.COIN;
            this.hasModeAugment = true;
            return true;
        }
        if (!this.augmentGear && "machineCompactorGear".equals(id)) {
            this.augmentGear = true;
            if (this.mode != CompactorManager.Mode.GEAR && this.isActive && !this.inventory[1].func_190926_b()) {
                this.processOff();
            }
            this.mode = CompactorManager.Mode.GEAR;
            this.hasModeAugment = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || CompactorManager.isItemValid(stack);
    }
}

