/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropSeedDropBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropBeetRoot
extends CropSeedDropBase {
    public CropBeetRoot(CropProperties properties) {
        super(new CropProperties(2, 0, 4, 0, 0, 2));
    }

    @Override
    public ItemStack getSeed(ICropTile tile) {
        return new ItemStack(Items.field_185163_cU);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state < 3) {
            return this.getSprite("bc")[47 + state];
        }
        return this.getSprite("bc")[67];
    }

    @Override
    public String getDiscoveredBy() {
        return "Notch";
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 3 && cropTile.getLightLevel() >= 9;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 3;
    }

    @Override
    public String getId() {
        return "BeetRoots";
    }

    @Override
    public int getMaxSize() {
        return 3;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 1;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 3;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Items.field_185164_cV);
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"BeetRoots", "Food", "Purple"};
    }
}

