/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.items;

import ic2.core.IC2;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.buttons.IconButton;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.inventory.management.AccessRule;
import ic2.core.item.inv.inventories.InventorySlotAccessModifier;
import ic2.core.network.fieldEvents.item.SlotTypeModifierFieldData;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlotAccessComp
extends GuiComponent {
    InventorySlotAccessModifier data;

    public SlotAccessComp(InventorySlotAccessModifier inv) {
        super(Ic2GuiComp.nullBox);
        this.data = inv;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.GuiTick);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        int max = Math.min(4, this.data.slots.size() - this.data.offset);
        for (int i = 0; i < max; ++i) {
            int realSlot = this.data.slots.get(this.data.offset + i);
            int boost = 30 * i;
            gui.drawString(Ic2GuiLang.invUpgradeSlotID.getLocalizedFormatted(realSlot), 4, 20 + boost, 0x404040);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        int max = Math.min(4, this.data.slots.size() - this.data.offset);
        for (int i = 0; i < max; ++i) {
            int boost = 30 * i;
            int slot = this.data.slots.get(this.data.offset + i);
            Map<EnumFacing, AccessRule> rules = this.data.rules.get(slot);
            for (int z = 0; z < 6; ++z) {
                EnumFacing side = EnumFacing.func_82600_a((int)z);
                gui.registerButton(new IconButton(z + 6 * i, x + 4 + z * 21, y + 28 + boost, 20, 20).setItemStack(Ic2Items.displayIcons[2 + side.func_176745_a()]).addText(Ic2Lang.getFacingComp(side)).addText(rules.get(side).getName()));
            }
        }
        gui.registerButton(new IC2Button(100, x + 152, y + 5, 20, 10, "-"));
        gui.registerButton(new IC2Button(101, x + 152, y + 118, 20, 10, "+"));
        gui.registerButton(new IC2Button(102, x + 130, y + 129, 42, 10, Ic2GuiLang.saveButton));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
        int max = Math.min(4, this.data.slots.size() - this.data.offset);
        for (int i = 0; i < max; ++i) {
            int slot = this.data.slots.get(this.data.offset + i);
            Map<EnumFacing, AccessRule> rules = this.data.rules.get(slot);
            for (int x = 0; x < 6; ++x) {
                EnumFacing side = EnumFacing.func_82600_a((int)x);
                gui.getCastedButton(i * 6 + x, IconButton.class).clearText().addText(Ic2Lang.getFacingComp(side)).addText(rules.get(side).getName());
            }
        }
        gui.getButton((int)100).field_146124_l = this.data.offset > 0;
        gui.getButton((int)101).field_146124_l = this.data.offset + 4 < this.data.slots.size();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int id = button.field_146127_k;
        if (id < 30) {
            int slot = this.data.slots.get(id / 6 + this.data.offset);
            Map<EnumFacing, AccessRule> rule = this.data.rules.get(slot);
            AccessRule master = this.data.masterRules.get(slot);
            EnumFacing side = EnumFacing.func_82600_a((int)id);
            rule.put(side, rule.get(side).createNextRule(master));
        }
        if (id == 100 && this.data.offset > 0) {
            --this.data.offset;
        }
        if (id == 101 && this.data.offset + 4 < this.data.slots.size()) {
            ++this.data.offset;
        }
        if (id == 102) {
            SlotTypeModifierFieldData fieldData = new SlotTypeModifierFieldData();
            fieldData.putData(this.data.rules);
            fieldData.putMasters(this.data.masterRules);
            fieldData.sendOff(this.data.isOffHand);
            IC2.network.get().initiateCustomClientItemEvent(this.data.stack, fieldData);
        }
    }
}

