/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.reactorPlanner;

import com.google.common.base.Strings;
import ic2.core.IC2;
import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.logic.encoder.ByteShifter;
import ic2.core.block.machine.med.logic.encoder.EncoderRegistry;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.network.fieldEvents.custom.PayloadFieldPacket;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReactorSettingsComp
extends GuiComponent {
    public static final DecimalFormat format = new DecimalFormat("###,###");
    TileEntityReactorPlanner planner;

    public ReactorSettingsComp(TileEntityReactorPlanner tile) {
        super(Ic2GuiComp.nullBox);
        this.planner = tile;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.GuiTick);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        gui.drawString("" + this.planner.stackSize, 240, 111, 0x404040);
        gui.drawCenteredString(Ic2GuiLang.reactorStartingHeat, 243, 125, 0x404040);
        gui.drawCenteredString(Ic2GuiLang.reactorCustomTime, 243, 149, 0x404040);
        gui.drawCenteredString(Ic2GuiLang.reactorSimSpeed, 243, 173, 0x404040);
        TileEntityReactorPlanner.UserSettings settings = this.planner.getUserSettings();
        gui.drawCenteredString(format.format(settings.startingHeat), 242, 136, 0x404040);
        gui.drawCenteredString(format.format(settings.maxTicks), 242, 160, 0x404040);
        gui.drawCenteredString(format.format(settings.ticksPerTick), 242, 184, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        gui.registerButton(new IC2Button(15, x + 205, y + 135, 10, 10, "-"));
        gui.registerButton(new IC2Button(16, x + 269, y + 135, 10, 10, "+"));
        gui.registerButton(new IC2Button(17, x + 205, y + 159, 10, 10, "-"));
        gui.registerButton(new IC2Button(18, x + 269, y + 159, 10, 10, "+"));
        gui.registerButton(new IC2Button(19, x + 205, y + 183, 10, 10, "-"));
        gui.registerButton(new IC2Button(20, x + 269, y + 183, 10, 10, "+"));
        gui.registerButton(new IC2Button(21, x + 175, y + 197, 40, 10, Ic2GuiLang.setupImport));
        gui.registerButton(new IC2Button(22, x + 220, y + 197, 40, 10, Ic2GuiLang.setupExport));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
        TileEntityReactorPlanner.UserSettings settings = this.planner.getUserSettings();
        gui.getButton((int)15).field_146124_l = settings.startingHeat > 0;
        gui.getButton((int)17).field_146124_l = settings.maxTicks > 0;
        gui.getButton((int)19).field_146124_l = settings.ticksPerTick > 1;
        gui.getButton((int)22).field_146124_l = this.planner.getReactorLogic().isValid();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int id = button.field_146127_k;
        ByteShifter shifter = new ByteShifter();
        int value = 0;
        if (id == 15 || id == 16) {
            value = this.getValue(gui, id == 15);
            shifter.writeInteger(0, 2);
        } else if (id == 17 || id == 18) {
            value = this.getValue(gui, id == 17);
            shifter.writeInteger(1, 2);
        } else if (id == 19 || id == 20) {
            value = this.getValue(gui, id == 19);
            shifter.writeInteger(2, 2);
        } else {
            if (id == 21) {
                Tuple<String, NBTTagCompound> encoded = this.getDecodedSetup();
                if (encoded == null) {
                    IC2.platform.messagePlayer(gui.getPlayer(), Ic2GuiLang.setupImportFailedNoDecoder);
                    return;
                }
                PayloadFieldPacket payload = new PayloadFieldPacket(2, 0, 0);
                payload.addString(0, (String)encoded.func_76341_a());
                payload.addString(1, ((NBTTagCompound)encoded.func_76340_b()).toString());
                this.planner.getNetwork().initiateCustomClientTileEntityEvent(this.planner, payload);
                return;
            }
            if (id == 22) {
                Tuple<String[], String[]> cases;
                int answer;
                String defaults = EncoderRegistry.instance.getDefaultEncoderID();
                if (gui.func_146272_n() && (answer = JOptionPane.showOptionDialog(null, "Choose a Encoder", "ReactorPlanner Enocder Choice", 1, 1, null, (Object[])(cases = EncoderRegistry.instance.getChoiceList()).func_76340_b(), EncoderRegistry.instance.getDefaultEncoder().getName())) != -1) {
                    defaults = ((String[])cases.func_76341_a())[answer];
                }
                PayloadFieldPacket payload = new PayloadFieldPacket(1, 1, 0);
                payload.addString(0, defaults);
                payload.addNumber(0, 0);
                this.planner.getNetwork().initiateCustomClientTileEntityEvent(this.planner, payload);
                return;
            }
            return;
        }
        shifter.writeInteger(2, 3);
        this.planner.getNetwork().initiateClientTileEntityEvent(this.planner, shifter.getEncodedData(), value);
    }

    @SideOnly(value=Side.CLIENT)
    public int getValue(GuiIC2 gui, boolean inv) {
        int value = 1;
        if (gui.func_146271_m()) {
            value *= 1000;
        }
        if (gui.func_146272_n()) {
            value *= 100;
        }
        if (gui.func_175283_s()) {
            value *= 10;
        }
        if (inv) {
            value = -value;
        }
        return value;
    }

    @SideOnly(value=Side.CLIENT)
    public Tuple<String, NBTTagCompound> getDecodedSetup() {
        String text = GuiScreen.func_146277_j();
        if (Strings.isNullOrEmpty((String)text)) {
            return null;
        }
        return EncoderRegistry.instance.createDecodedMessage(text);
    }
}

