/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.standart;

import ic2.api.classic.item.IHazmatSuit;
import ic2.core.IC2;
import ic2.core.entity.IC2DamageSource;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.armor.base.ItemIC2ArmorBase;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHazmatArmor
extends ItemIC2ArmorBase
implements IHazmatSuit,
ISpecialArmor {
    public ItemHazmatArmor(int index, EntityEquipmentSlot equipmentSlotIn) {
        super(ItemArmor.ArmorMaterial.DIAMOND, index, equipmentSlotIn);
        this.func_77656_e(64);
    }

    @Override
    public String getTexture() {
        return "ic2:textures/models/armor/hazmat";
    }

    @Override
    public ItemStack getRepairItem() {
        return Ic2Items.rubber.func_77946_l();
    }

    @Override
    public boolean isHazmatSuit(ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        List<String> shiftTip = sortedTooltip.get((Object)ToolTipType.Shift);
        shiftTip.add(Ic2InfoLang.rubberPreventBurn.getLocalized());
        if (this.field_77881_a == EntityEquipmentSlot.HEAD) {
            shiftTip.add(Ic2InfoLang.rubberProvidesAir.getLocalized());
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (this.field_77881_a == EntityEquipmentSlot.HEAD) {
            IItemTransporter trans;
            ItemStack stack;
            if (ItemHazmatArmor.isFullHazmatSuit((EntityLivingBase)player)) {
                if (player.func_180799_ab() || world.func_72875_a(player.func_174813_aQ().func_72321_a((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.field_151581_o)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 60, 1));
                }
                player.func_70066_B();
            }
            if (player.func_70086_ai() <= 100 && player.field_71071_by.func_70431_c(Ic2Items.airCell) && (stack = (trans = TransporterManager.manager.getTransporter(player, true)).removeItem(new BasicItemFilter(Ic2Items.airCell.func_77946_l()), EnumFacing.DOWN, 1, true)) != null) {
                trans.addItem(Ic2Items.emptyCell.func_77946_l(), EnumFacing.DOWN, true);
                player.func_70050_g(player.func_70086_ai() + 150);
                player.field_71070_bA.func_75142_b();
                IC2.achievements.issueStat(player, "airCellsUsed");
            }
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (this.field_77881_a == EntityEquipmentSlot.HEAD && this.hazmatAbsorbs(source) && ItemHazmatArmor.isFullHazmatSuit(player)) {
            if (source.func_76347_k()) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 60, 1));
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, Integer.MAX_VALUE);
        }
        if (this.field_77881_a == EntityEquipmentSlot.FEET && source == DamageSource.field_76379_h) {
            return new ISpecialArmor.ArmorProperties(10, damage < 8.0 ? 1.0 : 0.875, (armor.func_77958_k() - armor.func_77952_i() + 1) * 2 * 25);
        }
        return new ISpecialArmor.ArmorProperties(0, 1.0, (armor.func_77958_k() - armor.func_77952_i() + 1) / 2 * 25);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 1;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (this.hazmatAbsorbs(source) && ItemHazmatArmor.isFullHazmatSuit(entity)) {
            return;
        }
        if (source == DamageSource.field_76366_f || source == DamageSource.field_76379_h) {
            return;
        }
        int damageTotal = damage * 2;
        if (this.field_77881_a == EntityEquipmentSlot.FEET && source == DamageSource.field_76379_h) {
            damageTotal = (damage + 1) / 2;
        }
        stack.func_77972_a(damageTotal, entity);
    }

    public static boolean isFullHazmatSuit(EntityLivingBase base) {
        if (!(base instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)base;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.HAND) continue;
            ItemStack stack = player.func_184582_a(slot);
            if (stack == null || !(stack.func_77973_b() instanceof IHazmatSuit)) {
                return false;
            }
            IHazmatSuit suit = (IHazmatSuit)stack.func_77973_b();
            if (suit.isHazmatSuit(stack)) continue;
            return false;
        }
        return true;
    }

    public boolean hazmatAbsorbs(DamageSource source) {
        return source == DamageSource.field_76372_a || source == DamageSource.field_76368_d || source == DamageSource.field_76371_c || source == DamageSource.field_76370_b || source.func_76355_l().equals(IC2DamageSource.electricity.func_76355_l()) || source == IC2DamageSource.radiation;
    }
}

