/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.misc;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.IFoodCanEffect;
import ic2.core.IC2;
import ic2.core.inventory.filters.IFilter;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ItemTinCan
extends ItemIC2
implements IBootable {
    public static IFilter foodCanFilter = new FoodCanFilter();

    public ItemTinCan() {
        this.setUnlocalizedName(Ic2ItemLang.tinCan);
        this.func_77627_a(true);
    }

    @Override
    public void onLoad() {
        Ic2Items.filledTinCan = new ItemStack((Item)this, 1, 0);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 79;
    }

    @Override
    public String getSheet(int meta) {
        return "i0";
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_190926_b()) {
            return;
        }
        IFoodCanEffect effect = ClassicRecipes.canningMachine.getEffectFromID(stack.func_77952_i());
        if (effect != null && effect.isBadEffect(stack)) {
            tooltip.add(Ic2InfoLang.badFoodCan.getLocalized());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_71043_e(true)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            this.onFoodEaten(stack, worldIn, player);
        }
        stack.func_190918_g(1);
        return stack;
    }

    public void onFoodEaten(ItemStack stack, World world, EntityPlayer player) {
        IC2.achievements.issueStat(player, "foodcanEaten");
        player.func_70691_i(2.0f);
        ItemStack can = Ic2Items.tinCan.func_77946_l();
        if (!player.field_71071_by.func_70441_a(can)) {
            player.func_71019_a(can, false);
        } else {
            player.field_71070_bA.func_75142_b();
        }
        player.func_71024_bL().func_75122_a(2, 0.95f);
        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        player.func_71029_a(StatList.func_188057_b((Item)this));
        int meta = stack.func_77952_i();
        if (meta == 0) {
            return;
        }
        IFoodCanEffect effect = ClassicRecipes.canningMachine.getEffectFromID(meta);
        if (effect != null) {
            effect.onEaten(stack.func_77946_l(), world, player);
        }
    }

    public int getMetadata(ItemStack stack) {
        return 0;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.EAT;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        for (Integer meta : ClassicRecipes.canningMachine.getEffectMap().keySet()) {
            items.add((Object)new ItemStack((Item)this, 1, meta.intValue()));
        }
    }

    public static class FoodCanFilter
    implements IFilter {
        @Override
        public boolean matches(ItemStack stack) {
            return stack != null && stack.func_77973_b() instanceof ItemTinCan;
        }
    }
}

